/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.interactionhandling;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.View;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.interactionhandling.InteractionValidatorRegistry;
import com.minecolonies.api.colony.interactionhandling.ModInteractionResponseHandlers;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.client.gui.WindowRequestDetail;
import com.minecolonies.coremod.client.gui.citizen.RequestWindowCitizen;
import com.minecolonies.coremod.colony.interactionhandling.ServerCitizenInteraction;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class RequestBasedInteraction
extends ServerCitizenInteraction {
    private static final String TOKEN_TAG = "token";
    private static final Tuple<Component, Component>[] tuples = new Tuple[]{new Tuple<TranslatableComponent, Object>(new TranslatableComponent("com.minecolonies.coremod.gui.chat.okay"), null), new Tuple<TranslatableComponent, Object>(new TranslatableComponent("com.minecolonies.coremod.gui.chat.remindmelater"), null), new Tuple<TranslatableComponent, Object>(new TranslatableComponent("com.minecolonies.coremod.gui.chat.cancel"), null), new Tuple<TranslatableComponent, Object>(new TranslatableComponent("com.minecolonies.coremod.gui.chat.fulfill"), null)};
    private static final Tuple<Component, Component>[] tuplesAsync = new Tuple[]{new Tuple<TranslatableComponent, Object>(new TranslatableComponent("com.minecolonies.coremod.gui.chat.okay"), null), new Tuple<TranslatableComponent, Object>(new TranslatableComponent("com.minecolonies.coremod.gui.chat.ignore"), null), new Tuple<TranslatableComponent, Object>(new TranslatableComponent("com.minecolonies.coremod.gui.chat.remindmelater"), null), new Tuple<TranslatableComponent, Object>(new TranslatableComponent("com.minecolonies.coremod.gui.chat.skipchitchat"), null)};
    private IToken<?> token = null;
    private BiPredicate<ICitizenData, IToken<?>> validator;

    public RequestBasedInteraction(Component inquiry, IChatPriority priority, Component validator, IToken<?> token) {
        super(inquiry, true, priority, null, validator, priority == ChatPriority.BLOCKING ? tuples : tuplesAsync);
        this.validator = InteractionValidatorRegistry.getTokenBasedInteractionValidatorPredicate(validator);
        this.token = token;
    }

    public RequestBasedInteraction(Component inquiry, IChatPriority priority, IToken<?> token) {
        super(inquiry, true, priority, null, inquiry, tuples);
        this.validator = InteractionValidatorRegistry.getTokenBasedInteractionValidatorPredicate(inquiry);
        this.token = token;
    }

    public RequestBasedInteraction(ICitizen data) {
        super(data);
    }

    @Override
    public List<IInteractionResponseHandler> genChildInteractions() {
        return Collections.emptyList();
    }

    @Override
    public boolean isValid(ICitizenData citizen) {
        return this.validator == null && !this.parents.isEmpty() || this.validator != null && this.validator.test(citizen, this.token);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_(TOKEN_TAG, (Tag)StandardFactoryController.getInstance().serialize(this.token));
        return tag;
    }

    @Override
    public void deserializeNBT(@NotNull CompoundTag compoundNBT) {
        super.deserializeNBT(compoundNBT);
        this.token = (IToken)StandardFactoryController.getInstance().deserialize(compoundNBT.m_128469_(TOKEN_TAG));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWindowOpened(BOWindow window, ICitizenDataView dataView) {
        IRequest<?> request;
        IColonyView colony = IColonyManager.getInstance().getColonyView(dataView.getColonyId(), (ResourceKey<Level>)Minecraft.m_91087_().f_91074_.f_19853_.m_46472_());
        if (colony != null && (request = colony.getRequestManager().getRequestForToken(this.token)) != null) {
            View group = (View)window.findPaneOfTypeByID("interactionView", View.class);
            ItemIcon icon = (ItemIcon)window.findPaneOfTypeByID("request_item", ItemIcon.class);
            if (icon == null) {
                icon = new ItemIcon();
                group.addChild((Pane)icon);
            }
            icon.setID("request_item");
            icon.setSize(32, 32);
            if (!request.getDisplayStacks().isEmpty()) {
                icon.setItem(request.getDisplayStacks().get(0));
            }
            icon.setPosition(30, 60);
            icon.setVisible(true);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onClientResponseTriggered(Component response, Player player, ICitizenDataView data, BOWindow window) {
        if (response.equals(new TranslatableComponent("com.minecolonies.coremod.gui.chat.fulfill"))) {
            IRequest<?> request;
            IColonyView colony = IColonyManager.getInstance().getColonyView(data.getColonyId(), (ResourceKey<Level>)player.f_19853_.m_46472_());
            if (colony != null && (request = colony.getRequestManager().getRequestForToken(this.token)) != null) {
                RequestWindowCitizen windowCitizen = new RequestWindowCitizen(data);
                windowCitizen.open();
                WindowRequestDetail windowRequestDetail = new WindowRequestDetail(windowCitizen, request, data.getColonyId());
                windowRequestDetail.open();
                return false;
            }
        } else {
            return super.onClientResponseTriggered(response, player, data, window);
        }
        return true;
    }

    @Override
    public void onServerResponseTriggered(Component response, Player player, ICitizenData data) {
        super.onServerResponseTriggered(response, player, data);
        if (response.equals(new TranslatableComponent("com.minecolonies.coremod.gui.chat.cancel")) && data.getColony() != null) {
            data.getColony().getRequestManager().updateRequestState(this.token, RequestState.CANCELLED);
        }
    }

    @Override
    protected void loadValidator() {
        this.validator = InteractionValidatorRegistry.getTokenBasedInteractionValidatorPredicate(this.validatorId);
    }

    @Override
    public String getType() {
        return ModInteractionResponseHandlers.REQUEST.m_135815_();
    }
}

