/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.data;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemBuildingDataStore;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.SerializationIdentifierConstants;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class StandardRequestSystemBuildingDataStore
implements IRequestSystemBuildingDataStore {
    private IToken<?> id;
    private final Map<TypeToken<?>, Collection<IToken<?>>> openRequestsByRequestableType;
    private final Map<Integer, Collection<IToken<?>>> openRequestsByCitizen;
    private final Map<Integer, Collection<IToken<?>>> completedRequestsByCitizen;
    private final Map<IToken<?>, Integer> citizenByOpenRequest;

    public StandardRequestSystemBuildingDataStore(IToken<?> id, Map<TypeToken<?>, Collection<IToken<?>>> openRequestsByRequestableType, Map<Integer, Collection<IToken<?>>> openRequestsByCitizen, Map<Integer, Collection<IToken<?>>> completedRequestsByCitizen, Map<IToken<?>, Integer> citizenByOpenRequest) {
        this.id = id;
        this.openRequestsByRequestableType = openRequestsByRequestableType;
        this.openRequestsByCitizen = openRequestsByCitizen;
        this.completedRequestsByCitizen = completedRequestsByCitizen;
        this.citizenByOpenRequest = citizenByOpenRequest;
    }

    public StandardRequestSystemBuildingDataStore() {
        this(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new HashMap(), new HashMap(), new HashMap(), new HashMap());
    }

    @Override
    public Map<TypeToken<?>, Collection<IToken<?>>> getOpenRequestsByRequestableType() {
        return this.openRequestsByRequestableType;
    }

    @Override
    public Map<Integer, Collection<IToken<?>>> getOpenRequestsByCitizen() {
        return this.openRequestsByCitizen;
    }

    @Override
    public Map<Integer, Collection<IToken<?>>> getCompletedRequestsByCitizen() {
        return this.completedRequestsByCitizen;
    }

    @Override
    public Map<IToken<?>, Integer> getCitizensByRequest() {
        return this.citizenByOpenRequest;
    }

    @Override
    public IToken<?> getId() {
        return this.id;
    }

    @Override
    public void setId(IToken<?> id) {
        this.id = id;
    }

    public static class Factory
    implements IFactory<FactoryVoidInput, StandardRequestSystemBuildingDataStore> {
        @Override
        @NotNull
        public TypeToken<? extends StandardRequestSystemBuildingDataStore> getFactoryOutputType() {
            return TypeToken.of(StandardRequestSystemBuildingDataStore.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public StandardRequestSystemBuildingDataStore getNewInstance(@NotNull IFactoryController factoryController, @NotNull FactoryVoidInput factoryVoidInput, Object ... context) throws IllegalArgumentException {
            return new StandardRequestSystemBuildingDataStore();
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull StandardRequestSystemBuildingDataStore standardRequestSystemBuildingDataStore) {
            CompoundTag compound = new CompoundTag();
            compound.m_128365_("Token", (Tag)controller.serialize(standardRequestSystemBuildingDataStore.id));
            compound.m_128365_("OpenRequestByRequestableType", (Tag)standardRequestSystemBuildingDataStore.openRequestsByRequestableType.keySet().stream().map(typeToken -> {
                CompoundTag entryCompound = new CompoundTag();
                entryCompound.m_128365_("Token", (Tag)controller.serialize(typeToken));
                entryCompound.m_128365_("List", (Tag)standardRequestSystemBuildingDataStore.openRequestsByRequestableType.get(typeToken).stream().map(controller::serialize).collect(NBTUtils.toListNBT()));
                return entryCompound;
            }).collect(NBTUtils.toListNBT()));
            compound.m_128365_("OpenRequestByCitizen", (Tag)standardRequestSystemBuildingDataStore.openRequestsByCitizen.keySet().stream().map(integer -> {
                CompoundTag entryCompound = new CompoundTag();
                entryCompound.m_128365_("Token", (Tag)controller.serialize(integer));
                entryCompound.m_128365_("List", (Tag)standardRequestSystemBuildingDataStore.openRequestsByCitizen.get(integer).stream().map(controller::serialize).collect(NBTUtils.toListNBT()));
                return entryCompound;
            }).collect(NBTUtils.toListNBT()));
            compound.m_128365_("CompletedRequestByCitizen", (Tag)standardRequestSystemBuildingDataStore.completedRequestsByCitizen.keySet().stream().map(integer -> {
                CompoundTag entryCompound = new CompoundTag();
                entryCompound.m_128365_("Token", (Tag)controller.serialize(integer));
                entryCompound.m_128365_("List", (Tag)standardRequestSystemBuildingDataStore.completedRequestsByCitizen.get(integer).stream().map(controller::serialize).collect(NBTUtils.toListNBT()));
                return entryCompound;
            }).collect(NBTUtils.toListNBT()));
            compound.m_128365_("CitizenByOpenRequest", (Tag)standardRequestSystemBuildingDataStore.citizenByOpenRequest.keySet().stream().map(iToken -> {
                CompoundTag entryCompound = new CompoundTag();
                entryCompound.m_128365_("Token", (Tag)controller.serialize(iToken));
                entryCompound.m_128365_("Value", (Tag)controller.serialize(standardRequestSystemBuildingDataStore.citizenByOpenRequest.get(iToken)));
                return entryCompound;
            }).collect(NBTUtils.toListNBT()));
            return compound;
        }

        @Override
        @NotNull
        public StandardRequestSystemBuildingDataStore deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) throws Throwable {
            IToken token = (IToken)controller.deserialize(nbt.m_128469_("Token"));
            Map<TypeToken<?>, Collection<IToken<?>>> openRequestsByRequestableType = NBTUtils.streamCompound(nbt.m_128437_("OpenRequestByRequestableType", 10)).map(CompoundNBT -> {
                TypeToken key = (TypeToken)controller.deserialize(CompoundNBT.m_128469_("Token"));
                Collection values = NBTUtils.streamCompound(CompoundNBT.m_128437_("List", 10)).map(elementCompound -> (IToken)controller.deserialize((CompoundTag)elementCompound)).collect(Collectors.toList());
                return new Tuple((Object)key, (Object)values);
            }).collect(Collectors.toMap(Tuple::m_14418_, Tuple::m_14419_));
            Map<Integer, Collection<IToken<?>>> openRequestsByCitizen = NBTUtils.streamCompound(nbt.m_128437_("OpenRequestByCitizen", 10)).map(CompoundNBT -> {
                Integer key = (Integer)controller.deserialize(CompoundNBT.m_128469_("Token"));
                Collection values = NBTUtils.streamCompound(CompoundNBT.m_128437_("List", 10)).map(elementCompound -> (IToken)controller.deserialize((CompoundTag)elementCompound)).collect(Collectors.toList());
                return new Tuple((Object)key, (Object)values);
            }).collect(Collectors.toMap(Tuple::m_14418_, Tuple::m_14419_));
            Map<Integer, Collection<IToken<?>>> completedRequestsByCitizen = NBTUtils.streamCompound(nbt.m_128437_("CompletedRequestByCitizen", 10)).map(CompoundNBT -> {
                Integer key = (Integer)controller.deserialize(CompoundNBT.m_128469_("Token"));
                Collection values = NBTUtils.streamCompound(CompoundNBT.m_128437_("List", 10)).map(elementCompound -> (IToken)controller.deserialize((CompoundTag)elementCompound)).collect(Collectors.toList());
                return new Tuple((Object)key, (Object)values);
            }).collect(Collectors.toMap(Tuple::m_14418_, Tuple::m_14419_));
            Map<IToken<?>, Integer> citizenByOpenRequest = NBTUtils.streamCompound(nbt.m_128437_("CitizenByOpenRequest", 10)).map(CompoundNBT -> {
                IToken key = (IToken)controller.deserialize(CompoundNBT.m_128469_("Token"));
                Integer value = (Integer)controller.deserialize(CompoundNBT.m_128469_("Value"));
                return new Tuple((Object)key, (Object)value);
            }).collect(Collectors.toMap(Tuple::m_14418_, Tuple::m_14419_));
            return new StandardRequestSystemBuildingDataStore(token, openRequestsByRequestableType, openRequestsByCitizen, completedRequestsByCitizen, citizenByOpenRequest);
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequestSystemBuildingDataStore input, FriendlyByteBuf packetBuffer) {
            controller.serialize(packetBuffer, input.id);
            packetBuffer.writeInt(input.openRequestsByRequestableType.size());
            input.openRequestsByRequestableType.forEach((key, value) -> {
                controller.serialize(packetBuffer, key);
                packetBuffer.writeInt(value.size());
                value.forEach(token -> controller.serialize(packetBuffer, token));
            });
            packetBuffer.writeInt(input.openRequestsByCitizen.size());
            input.openRequestsByCitizen.forEach((key, value) -> {
                packetBuffer.writeInt(key.intValue());
                packetBuffer.writeInt(value.size());
                value.forEach(token -> controller.serialize(packetBuffer, token));
            });
            packetBuffer.writeInt(input.completedRequestsByCitizen.size());
            input.completedRequestsByCitizen.forEach((key, value) -> {
                packetBuffer.writeInt(key.intValue());
                packetBuffer.writeInt(value.size());
                value.forEach(token -> controller.serialize(packetBuffer, token));
            });
            packetBuffer.writeInt(input.citizenByOpenRequest.size());
            input.citizenByOpenRequest.forEach((key, value) -> {
                controller.serialize(packetBuffer, key);
                controller.serialize(packetBuffer, value);
            });
        }

        @Override
        public StandardRequestSystemBuildingDataStore deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
            IToken id = (IToken)controller.deserialize(buffer);
            HashMap openRequestsByRequestableType = new HashMap();
            int openRequestsByRequestableTypeSize = buffer.readInt();
            for (int i = 0; i < openRequestsByRequestableTypeSize; ++i) {
                TypeToken key = (TypeToken)controller.deserialize(buffer);
                ArrayList<IToken> tokens = new ArrayList<IToken>();
                int tokensSize = buffer.readInt();
                for (int ii = 0; ii < tokensSize; ++ii) {
                    tokens.add((IToken)controller.deserialize(buffer));
                }
                openRequestsByRequestableType.put(key, tokens);
            }
            HashMap openRequestsByCitizen = new HashMap();
            int openRequestsByCitizenSize = buffer.readInt();
            for (int i = 0; i < openRequestsByCitizenSize; ++i) {
                int key = buffer.readInt();
                ArrayList<IToken> tokens = new ArrayList<IToken>();
                int tokensSize = buffer.readInt();
                for (int ii = 0; ii < tokensSize; ++ii) {
                    tokens.add((IToken)controller.deserialize(buffer));
                }
                openRequestsByCitizen.put(key, tokens);
            }
            HashMap completedRequestsByCitizen = new HashMap();
            int completedRequestsByCitizenSize = buffer.readInt();
            for (int i = 0; i < completedRequestsByCitizenSize; ++i) {
                int key = buffer.readInt();
                ArrayList<IToken> tokens = new ArrayList<IToken>();
                int tokensSize = buffer.readInt();
                for (int ii = 0; ii < tokensSize; ++ii) {
                    tokens.add((IToken)controller.deserialize(buffer));
                }
                completedRequestsByCitizen.put(key, tokens);
            }
            HashMap citizenByOpenRequest = new HashMap();
            int citizenByOpenRequestSize = buffer.readInt();
            for (int i = 0; i < citizenByOpenRequestSize; ++i) {
                citizenByOpenRequest.put((IToken)controller.deserialize(buffer), (Integer)controller.deserialize(buffer));
            }
            return new StandardRequestSystemBuildingDataStore(id, openRequestsByRequestableType, openRequestsByCitizen, completedRequestsByCitizen, citizenByOpenRequest);
        }

        @Override
        public short getSerializationId() {
            return SerializationIdentifierConstants.STANDARD_REQUEST_SYSTEM_BUILDING_DATASTORE_ID;
        }
    }
}

