/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders;

import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class WorkOrderBuild
extends WorkOrderBuildDecoration {
    private static final String TAG_UPGRADE_LEVEL = "upgradeLevel";
    private static final String TAG_UPGRADE_NAME = "upgrade";
    private static final String TAG_DISP_NAME = "displayname";
    private static final double MAX_DISTANCE_SQ = 10000.0;
    private int upgradeLevel;
    private String upgradeName;
    private String displayName = "";

    public WorkOrderBuild() {
    }

    public WorkOrderBuild(@NotNull IBuilding building, int level) {
        IBuilding parentBuilding;
        this.buildingLocation = building.getID();
        this.upgradeLevel = level;
        BlockEntity buildingTE = building.getColony().getWorld().m_7702_(this.buildingLocation);
        this.upgradeName = buildingTE instanceof AbstractTileEntityColonyBuilding ? (!((AbstractTileEntityColonyBuilding)buildingTE).getSchematicName().isEmpty() ? ((AbstractTileEntityColonyBuilding)buildingTE).getSchematicName().replaceAll("\\d$", "") + level : building.getSchematicName() + level) : building.getSchematicName() + level;
        this.buildingRotation = building.getRotation();
        this.isBuildingMirrored = building.getTileEntity() == null ? building.isMirrored() : building.getTileEntity().isMirrored();
        this.cleared = level > 1;
        StructureName sn = new StructureName("schematics", building.getStyle(), this.getUpgradeName());
        this.workOrderName = this.structureName = sn.toString();
        if (building.hasParent() && (parentBuilding = building.getColony().getBuildingManager().getBuilding(building.getParent())) != null) {
            this.displayName = parentBuilding.getCustomBuildingName() + "/";
        }
        this.displayName = this.displayName + building.getCustomBuildingName() + level;
    }

    @Override
    public void serializeViewNetworkData(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.getPriority());
        buf.m_130064_(this.getClaimedBy() == null ? BlockPos.f_121853_ : this.getClaimedBy());
        buf.writeInt(this.getType().ordinal());
        buf.m_130070_(this.upgradeName);
        buf.m_130070_(this.getDisplayName());
        buf.m_130064_(this.buildingLocation == null ? BlockPos.f_121853_ : this.buildingLocation);
        buf.writeInt(this.upgradeLevel);
    }

    public String getUpgradeName() {
        return this.upgradeName;
    }

    @Override
    public void read(@NotNull CompoundTag compound, IWorkManager manager) {
        super.read(compound, manager);
        this.upgradeLevel = compound.m_128451_(TAG_UPGRADE_LEVEL);
        this.upgradeName = compound.m_128461_(TAG_UPGRADE_NAME);
        this.displayName = compound.m_128461_(TAG_DISP_NAME);
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        super.write(compound);
        compound.m_128405_(TAG_UPGRADE_LEVEL, this.upgradeLevel);
        compound.m_128359_(TAG_UPGRADE_NAME, this.upgradeName);
        compound.m_128359_(TAG_DISP_NAME, this.displayName);
    }

    @Override
    protected void sendBuilderMessage(@NotNull Colony colony, boolean hasBuilder, boolean sendMessage) {
        if (this.hasSentMessageForThisWorkOrder) {
            return;
        }
        if (hasBuilder && sendMessage) {
            this.hasSentMessageForThisWorkOrder = true;
            LanguageHandler.sendPlayersMessage(colony.getMessagePlayerEntities(), (String)"entity.builder.messageBuilderNecessary", (Object[])new Object[]{Integer.toString(this.upgradeLevel)});
        }
        if (!hasBuilder) {
            this.hasSentMessageForThisWorkOrder = true;
            LanguageHandler.sendPlayersMessage(colony.getMessagePlayerEntities(), (String)"entity.builder.messageNoBuilder", (Object[])new Object[0]);
        }
    }

    @Override
    public boolean canBuild(@NotNull ICitizenData citizen) {
        IBuilding building = citizen.getWorkBuilding();
        return this.canBuildIngoringDistance(building.getPosition(), building.getBuildingLevel()) && citizen.getWorkBuilding().getPosition().m_123331_((Vec3i)this.getSchematicLocation()) <= 10000.0;
    }

    public boolean canBuildIngoringDistance(@NotNull BlockPos builderLocation, int builderLevel) {
        return builderLevel >= this.upgradeLevel || builderLevel == 5 || builderLocation.equals((Object)this.buildingLocation);
    }

    @Override
    public boolean tooFarFromAnyBuilder(IColony colony, int level) {
        return colony.getBuildingManager().getBuildings().values().stream().noneMatch(building -> building instanceof BuildingBuilder && !building.getAllAssignedCitizen().isEmpty() && building.getPosition().m_123331_((Vec3i)this.getSchematicLocation()) <= 10000.0);
    }

    @Override
    public boolean isValid(@NotNull IColony colony) {
        return super.isValid(colony) && colony.getBuildingManager().getBuilding(this.buildingLocation) != null;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName.isEmpty()) {
            return this.upgradeName;
        }
        return this.displayName;
    }

    @Override
    public int getRotation(Level world) {
        return this.buildingRotation;
    }

    @Override
    public void onAdded(IColony colony, boolean readingFromNbt) {
        IBuilding building;
        if (!readingFromNbt && colony != null && colony.getWorld() != null && (building = colony.getBuildingManager().getBuilding(this.getSchematicLocation())) != null) {
            ConstructionTapeHelper.placeConstructionTape(building.getCorners(), colony.getWorld());
        }
    }

    @Override
    public void onRemoved(IColony colony) {
        IBuilding building = colony.getBuildingManager().getBuilding(this.getSchematicLocation());
        if (building != null) {
            building.markDirty();
            ConstructionTapeHelper.removeConstructionTape(building.getCorners(), colony.getWorld());
        }
    }

    private static boolean isLocationTownhall(@NotNull IColony colony, BlockPos buildingLocation) {
        return colony.hasTownHall() && colony.getBuildingManager().getTownHall() != null && colony.getBuildingManager().getTownHall().getID().equals((Object)buildingLocation);
    }

    public int getUpgradeLevel() {
        return this.upgradeLevel;
    }
}

