/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders;

import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.util.AdvancementUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WorkOrderBuildDecoration
extends AbstractWorkOrder {
    private static final String TAG_WORKORDER_NAME = "workOrderName";
    private static final String TAG_IS_CLEARED = "cleared";
    private static final String TAG_IS_REQUESTED = "requested";
    private static final String TAG_IS_MIRRORED = "mirrored";
    private static final String TAG_SCHEMATIC_NAME = "structureName";
    private static final String TAG_BUILDING_ROTATION = "buildingRotation";
    private static final String TAG_AMOUNT_OF_RES = "resQuantity";
    protected boolean isBuildingMirrored;
    protected int buildingRotation;
    protected String structureName;
    protected boolean cleared;
    protected String workOrderName;
    protected int amountOfRes;
    protected boolean levelUp = false;
    protected boolean hasSentMessageForThisWorkOrder = false;
    private boolean requested;

    public WorkOrderBuildDecoration() {
    }

    public WorkOrderBuildDecoration(String structureName, String workOrderName, int rotation, BlockPos location, boolean mirror) {
        StructureName sn = new StructureName(structureName);
        this.structureName = sn.toString();
        this.workOrderName = workOrderName;
        this.buildingRotation = rotation;
        this.buildingLocation = location;
        this.cleared = false;
        this.isBuildingMirrored = mirror;
        this.requested = false;
    }

    public void setLevelUp() {
        this.levelUp = true;
    }

    public String getName() {
        return this.workOrderName.replaceAll("schematics/(?:decorations/)?", "");
    }

    @Override
    public void read(@NotNull CompoundTag compound, IWorkManager manager) {
        super.read(compound, manager);
        StructureName sn = new StructureName(compound.m_128461_(TAG_SCHEMATIC_NAME));
        this.structureName = sn.toString();
        this.workOrderName = compound.m_128461_(TAG_WORKORDER_NAME);
        this.cleared = compound.m_128471_(TAG_IS_CLEARED);
        this.buildingRotation = compound.m_128451_(TAG_BUILDING_ROTATION);
        this.requested = compound.m_128471_(TAG_IS_REQUESTED);
        this.isBuildingMirrored = compound.m_128471_(TAG_IS_MIRRORED);
        this.amountOfRes = compound.m_128451_(TAG_AMOUNT_OF_RES);
        this.levelUp = compound.m_128471_("level");
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        super.write(compound);
        if (this.workOrderName != null) {
            compound.m_128359_(TAG_WORKORDER_NAME, this.workOrderName);
        }
        compound.m_128379_(TAG_IS_CLEARED, this.cleared);
        if (this.structureName == null) {
            Log.getLogger().error("WorkOrderBuild.write: structureName should not be null!!!", (Throwable)new Exception());
        } else {
            compound.m_128359_(TAG_SCHEMATIC_NAME, this.structureName);
        }
        compound.m_128405_(TAG_BUILDING_ROTATION, this.buildingRotation);
        compound.m_128379_(TAG_IS_REQUESTED, this.requested);
        compound.m_128379_(TAG_IS_MIRRORED, this.isBuildingMirrored);
        compound.m_128405_(TAG_AMOUNT_OF_RES, this.amountOfRes);
        compound.m_128379_("level", this.levelUp);
    }

    @Override
    public boolean isValid(IColony colony) {
        return this.structureName != null && super.isValid(colony);
    }

    @Override
    @NotNull
    protected WorkOrderType getType() {
        return WorkOrderType.BUILD;
    }

    @Override
    public String getDisplayName() {
        return this.workOrderName;
    }

    @Override
    public void onAdded(IColony colony, boolean readingFromNbt) {
        super.onAdded(colony, readingFromNbt);
        if (!readingFromNbt && colony != null && colony.getWorld() != null) {
            ConstructionTapeHelper.placeConstructionTape(this, colony.getWorld());
            LanguageHandler.sendPlayersMessage(colony.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.decoorderadded", (Object[])new Object[]{colony.getName()});
        }
    }

    @Override
    public void onRemoved(IColony colony) {
        super.onRemoved(colony);
        ConstructionTapeHelper.removeConstructionTape(this, colony.getWorld());
    }

    protected boolean canBuild(@NotNull ICitizenData citizen) {
        return true;
    }

    protected void sendBuilderMessage(@NotNull Colony colony, boolean hasBuilder, boolean sendMessage) {
        if (this.hasSentMessageForThisWorkOrder || hasBuilder) {
            return;
        }
        this.hasSentMessageForThisWorkOrder = true;
        LanguageHandler.sendPlayersMessage(colony.getMessagePlayerEntities(), (String)"entity.builder.messageNoBuilder", (Object[])new Object[0]);
    }

    @Override
    public void onCompleted(IColony colony, ICitizenData citizen) {
        super.onCompleted(colony, citizen);
        StructureName structureName = new StructureName(this.getStructureName());
        if (this instanceof WorkOrderBuildBuilding) {
            int level = ((WorkOrderBuildBuilding)this).getUpgradeLevel();
            AdvancementUtils.TriggerAdvancementPlayersForColony(colony, player -> AdvancementTriggers.COMPLETE_BUILD_REQUEST.trigger((ServerPlayer)player, structureName, level));
        } else {
            AdvancementUtils.TriggerAdvancementPlayersForColony(colony, player -> AdvancementTriggers.COMPLETE_BUILD_REQUEST.trigger((ServerPlayer)player, structureName, 0));
        }
    }

    public String getStructureName() {
        return this.structureName;
    }

    public BlockPos getSchematicLocation() {
        return this.buildingLocation;
    }

    public int getRotation(Level world) {
        return this.buildingRotation;
    }

    public boolean isCleared() {
        return this.cleared;
    }

    public void setCleared(boolean cleared) {
        this.cleared = cleared;
    }

    public boolean isRequested() {
        return this.requested;
    }

    public void setRequested(boolean requested) {
        this.requested = requested;
    }

    public boolean isMirrored() {
        return this.isBuildingMirrored;
    }

    public int getAmountOfRes() {
        return this.amountOfRes;
    }

    public void setAmountOfRes(int amountOfRes) {
        this.amountOfRes = amountOfRes;
    }
}

