/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IChunkmanagerCapability;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCOPCommand;
import com.minecolonies.coremod.util.ChunkDataHelper;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CommandClaimChunks
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        Entity sender = ((CommandSourceStack)context.getSource()).m_81373_();
        if (!(sender instanceof Player)) {
            return 0;
        }
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        int range = IntegerArgumentType.getInteger(context, (String)"range");
        if (range > (Integer)MineColonies.getConfig().getServer().maxColonySize.get()) {
            LanguageHandler.sendPlayerMessage((Player)((Player)sender), (String)"com.minecolonies.command.claim.toolarge", (Object[])new Object[]{colonyID});
            return 0;
        }
        boolean add = BoolArgumentType.getBool(context, (String)"add");
        IChunkmanagerCapability chunkManager = sender.f_19853_.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return 0;
        }
        if (chunkManager.getAllChunkStorages().size() > 5000) {
            LanguageHandler.sendPlayerMessage((Player)((Player)sender), (String)"com.minecolonies.command.claim.maxchunks", (Object[])new Object[0]);
            return 0;
        }
        ChunkDataHelper.claimChunksInRange(colonyID, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).m_81372_().m_46472_(), add, new BlockPos(sender.m_20182_()), range, 0, sender.f_19853_);
        if (add) {
            LanguageHandler.sendPlayerMessage((Player)((Player)sender), (String)"com.minecolonies.command.claim.success", (Object[])new Object[0]);
        } else {
            LanguageHandler.sendPlayerMessage((Player)((Player)sender), (String)"com.minecolonies.command.claim.unclaim", (Object[])new Object[0]);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "claim";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("range", IntegerArgumentType.integer((int)0, (int)10)).then(IMCCommand.newArgument("add", BoolArgumentType.bool()).executes(this::checkPreConditionAndExecute))));
    }
}

