/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class CommandColonyInfo
implements IMCCommand {
    private static final String ID_TEXT = "ID: ";
    private static final String NAME_TEXT = "Name: ";
    private static final String MAYOR_TEXT = "Mayor: ";
    private static final String COORDINATES_TEXT = "Coordinates: ";
    private static final String COORDINATES_XYZ = "x=%s y=%s z=%s";
    private static final String CITIZENS = "Citizens: ";
    private static final String LAST_CONTACT_TEXT = "Last contact with Owner or Officer: %d hours ago!";
    private static final String IS_DELETABLE = "If true this colony cannot be deleted: ";
    private static final String CANNOT_BE_RAIDED = "This colony is unable to be raided";

    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).m_81372_().m_46472_());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        if (!((CommandSourceStack)context.getSource()).m_6761_(4) && !((Boolean)MineColonies.getConfig().getServer().canPlayerUseShowColonyInfoCommand.get()).booleanValue()) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.notenabledinconfig", (Object[])new Object[0]), true);
            return 0;
        }
        BlockPos position = colony.getCenter();
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(ID_TEXT + colony.getID() + NAME_TEXT + colony.getName()), true);
        String mayor = colony.getPermissions().getOwnerName();
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(MAYOR_TEXT + mayor), true);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(CITIZENS + colony.getCitizenManager().getCurrentCitizenCount() + "/" + colony.getCitizenManager().getMaxCitizens()), true);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(COORDINATES_TEXT + String.format(COORDINATES_XYZ, position.m_123341_(), position.m_123342_(), position.m_123343_())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(String.format(LAST_CONTACT_TEXT, colony.getLastContactInHours())), true);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(IS_DELETABLE + !colony.canBeAutoDeleted()), true);
        if (!colony.getRaiderManager().canHaveRaiderEvents()) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(CANNOT_BE_RAIDED), true);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "info";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute));
    }
}

