/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei;

import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.loot.ModLootTables;
import com.minecolonies.coremod.colony.crafting.CustomRecipeManager;
import com.minecolonies.coremod.colony.crafting.LootTableAnalyzer;
import com.minecolonies.coremod.compatibility.jei.JobBasedRecipeCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FishermanRecipeCategory
extends JobBasedRecipeCategory<FishingRecipe> {
    private static final int LOOT_SLOTS_X = 53;
    private static final int LOOT_SLOTS_W = 114;

    public FishermanRecipeCategory(@NotNull IGuiHelper guiHelper) {
        super(ModJobs.fisherman.produceJob(null), ModJobs.FISHERMAN_ID, new ItemStack(ModBuildings.fisherman.getBuildingBlock()), guiHelper);
    }

    @NotNull
    public Class<? extends FishingRecipe> getRecipeClass() {
        return FishingRecipe.class;
    }

    @Override
    @NotNull
    protected List<Component> generateInfoBlocks(@NotNull FishingRecipe recipe) {
        return Collections.singletonList(new TranslatableComponent("com.minecolonies.coremod.jei.onelevelrestriction", new Object[]{recipe.getLevel()}));
    }

    public void setIngredients(@NotNull FishingRecipe recipe, @NotNull IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)Items.f_42523_));
        ingredients.setOutputLists(VanillaTypes.ITEM, new ArrayList(recipe.getDrops().stream().map(LootTableAnalyzer.LootDrop::getItemStacks).collect(Collectors.toList())));
    }

    public void setRecipe(@NotNull IRecipeLayout layout, @NotNull FishingRecipe recipe, @NotNull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        guiItemStacks.init(0, true, 149, 26);
        guiItemStacks.setBackground(0, (IDrawable)this.slot);
        guiItemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        if (!recipe.getDrops().isEmpty()) {
            int startX;
            int initialColumns = 114 / this.slot.getWidth();
            int rows = (recipe.getDrops().size() + initialColumns - 1) / initialColumns;
            int columns = (recipe.getDrops().size() + rows - 1) / rows;
            int x = startX = 53 + (114 - columns * this.slot.getWidth()) / 2;
            int y = 117 - rows * this.slot.getHeight() + 1;
            int c = 0;
            int slot = 1;
            guiItemStacks.addTooltipCallback((ITooltipCallback)new JobBasedRecipeCategory.LootTableTooltipCallback(slot, recipe.getDrops(), recipe.getId()));
            for (LootTableAnalyzer.LootDrop drop : recipe.getDrops()) {
                guiItemStacks.init(slot, true, x, y);
                guiItemStacks.setBackground(slot, (IDrawable)this.chanceSlot);
                guiItemStacks.set(slot, drop.getItemStacks());
                ++slot;
                if (++c >= columns) {
                    c = 0;
                    x = startX;
                    y += this.slot.getHeight();
                    continue;
                }
                x += this.slot.getWidth();
            }
        }
    }

    @NotNull
    public static List<FishingRecipe> findRecipes() {
        List<LootTableAnalyzer.LootDrop> commonDrops = CustomRecipeManager.getInstance().getLootDrops(ModLootTables.FISHING);
        ArrayList<FishingRecipe> recipes = new ArrayList<FishingRecipe>();
        for (Map.Entry<Integer, ResourceLocation> level : ModLootTables.FISHERMAN_BONUS.entrySet()) {
            ArrayList<LootTableAnalyzer.LootDrop> drops = new ArrayList<LootTableAnalyzer.LootDrop>(commonDrops);
            drops.addAll(CustomRecipeManager.getInstance().getLootDrops(level.getValue()));
            recipes.add(new FishingRecipe(level.getValue(), level.getKey(), drops));
        }
        return recipes;
    }

    public static class FishingRecipe {
        private final ResourceLocation id;
        private final int level;
        @NotNull
        private final List<LootTableAnalyzer.LootDrop> drops;

        public FishingRecipe(@NotNull ResourceLocation id, int level, @NotNull List<LootTableAnalyzer.LootDrop> drops) {
            this.id = id;
            this.level = level;
            this.drops = drops.size() > 18 ? LootTableAnalyzer.consolidate(drops) : drops;
        }

        @NotNull
        public ResourceLocation getId() {
            return this.id;
        }

        public int getLevel() {
            return this.level;
        }

        @NotNull
        public List<LootTableAnalyzer.LootDrop> getDrops() {
            return this.drops;
        }
    }
}

