/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei;

import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.coremod.colony.crafting.CustomRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GenericRecipeUtils {
    private GenericRecipeUtils() {
    }

    @NotNull
    public static List<Component> calculateRestrictions(@NotNull CustomRecipe customRecipe) {
        Component researchName;
        ArrayList<Component> restrictions = new ArrayList<Component>();
        if (customRecipe.getMinBuildingLevel() == customRecipe.getMaxBuildingLevel()) {
            restrictions.add((Component)new TranslatableComponent("com.minecolonies.coremod.jei.onelevelrestriction", new Object[]{customRecipe.getMinBuildingLevel()}));
        } else if (customRecipe.getMinBuildingLevel() > 1 || customRecipe.getMaxBuildingLevel() < 5) {
            restrictions.add((Component)new TranslatableComponent("com.minecolonies.coremod.jei.levelrestriction", new Object[]{customRecipe.getMinBuildingLevel(), customRecipe.getMaxBuildingLevel()}));
        }
        if (customRecipe.getRequiredResearchId() != null) {
            researchName = GenericRecipeUtils.getResearchDisplayName(customRecipe.getRequiredResearchId());
            restrictions.add((Component)new TranslatableComponent("com.minecolonies.coremod.jei.minresearch", new Object[]{researchName}));
        }
        if (customRecipe.getExcludedResearchId() != null) {
            researchName = GenericRecipeUtils.getResearchDisplayName(customRecipe.getExcludedResearchId());
            restrictions.add((Component)new TranslatableComponent("com.minecolonies.coremod.jei.maxresearch", new Object[]{researchName}));
        }
        return restrictions;
    }

    @NotNull
    public static IGenericRecipe create(@NotNull CustomRecipe customRecipe, @NotNull IRecipeStorage storage) {
        List<Component> restrictions = GenericRecipeUtils.calculateRestrictions(customRecipe);
        return Objects.requireNonNull(GenericRecipe.of(storage, restrictions, customRecipe.getMinBuildingLevel()));
    }

    @NotNull
    public static IGenericRecipe create(@NotNull Recipe<?> recipe) {
        IGenericRecipe original = Objects.requireNonNull(GenericRecipe.of(recipe));
        List<List<ItemStack>> inputs = GenericRecipeUtils.compact((NonNullList<Ingredient>)recipe.m_7527_());
        return new GenericRecipe(original.getRecipeId(), original.getPrimaryOutput(), original.getAdditionalOutputs(), inputs, original.getGridSize(), original.getIntermediate(), original.getLootTable(), new ArrayList<Component>(), -1);
    }

    @Nullable
    public static IGenericRecipe filterInputs(@NotNull IGenericRecipe recipe, @NotNull OptionalPredicate<ItemStack> predicate) {
        ArrayList<List<ItemStack>> newInputs = new ArrayList<List<ItemStack>>();
        boolean modified = false;
        for (List<ItemStack> slot : recipe.getInputs()) {
            List newSlot = slot.stream().filter(stack -> predicate.test((ItemStack)stack).orElse(true)).collect(Collectors.toList());
            if (newSlot.isEmpty() && !slot.isEmpty()) {
                return null;
            }
            modified |= newSlot.size() != slot.size();
            newInputs.add(newSlot);
        }
        if (!modified) {
            return recipe;
        }
        return new GenericRecipe(recipe.getRecipeId(), recipe.getPrimaryOutput(), recipe.getAdditionalOutputs(), newInputs, recipe.getGridSize(), recipe.getIntermediate(), recipe.getLootTable(), recipe.getRestrictions(), recipe.getLevelSort());
    }

    @NotNull
    private static Component getResearchDisplayName(@NotNull ResourceLocation researchId) {
        IGlobalResearchTree researchTree = IGlobalResearchTree.getInstance();
        IGlobalResearch research = researchTree.getResearch(researchId);
        if (research != null) {
            return research.getName();
        }
        Set<IGlobalResearch> researches = researchTree.getResearchForEffect(researchId);
        if (researches != null && !researches.isEmpty()) {
            return researches.iterator().next().getName();
        }
        return new TextComponent("???");
    }

    private static List<List<ItemStack>> compact(NonNullList<Ingredient> inputs) {
        HashMap<IngredientStacks, IngredientStacks> ingredients = new HashMap<IngredientStacks, IngredientStacks>();
        for (Ingredient ingredient : inputs) {
            IngredientStacks newIngredient;
            if (ingredient == Ingredient.f_43901_ || !(newIngredient = new IngredientStacks(ingredient)).getStacks().isEmpty() && newIngredient.getStacks().get(0).m_41720_() == ModItems.buildTool.get()) continue;
            IngredientStacks existing = (IngredientStacks)ingredients.get(newIngredient);
            if (existing == null) {
                ingredients.put(newIngredient, newIngredient);
                continue;
            }
            existing.merge(newIngredient);
        }
        return (List)ingredients.values().stream().sorted(Comparator.reverseOrder()).map(IngredientStacks::getStacks).collect(Collectors.toCollection(NonNullList::m_122779_));
    }

    private static class IngredientStacks
    implements Comparable<IngredientStacks> {
        private final List<ItemStack> stacks;
        private final Set<Item> items;

        public IngredientStacks(Ingredient ingredient) {
            this.stacks = Collections.unmodifiableList(Arrays.stream(ingredient.m_43908_()).filter(stack -> !stack.m_41619_()).map(ItemStack::m_41777_).collect(Collectors.toList()));
            this.items = this.stacks.stream().map(ItemStack::m_41720_).collect(Collectors.toSet());
        }

        @NotNull
        public List<ItemStack> getStacks() {
            return this.stacks;
        }

        public int getCount() {
            return this.stacks.isEmpty() ? 0 : this.stacks.get(0).m_41613_();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IngredientStacks that = (IngredientStacks)o;
            return this.items.equals(that.items);
        }

        public int hashCode() {
            return this.items.hashCode();
        }

        @Override
        public int compareTo(@NotNull IngredientStacks o) {
            int diff = this.getCount() - o.getCount();
            if (diff != 0) {
                return diff;
            }
            diff = this.stacks.size() - o.stacks.size();
            if (diff != 0) {
                return diff;
            }
            return this.hashCode() - o.hashCode();
        }

        public void merge(@NotNull IngredientStacks other) {
            for (int i = 0; i < this.stacks.size(); ++i) {
                this.stacks.get(i).m_41769_(other.stacks.get(i).m_41613_());
            }
        }

        public String toString() {
            return "IngredientStacks{stacks=" + this.stacks + ", items=" + this.items + "}";
        }
    }
}

