/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei;

import com.google.common.collect.ImmutableMap;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.CompostRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.buildings.modules.AnimalHerdingModule;
import com.minecolonies.coremod.colony.crafting.CustomRecipesReloadedEvent;
import com.minecolonies.coremod.compatibility.jei.CompostRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.FishermanRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.GenericRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.GenericRecipeUtils;
import com.minecolonies.coremod.compatibility.jei.HerderRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.JobBasedRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.transfer.CraftingGuiHandler;
import com.minecolonies.coremod.compatibility.jei.transfer.FurnaceCraftingGuiHandler;
import com.minecolonies.coremod.compatibility.jei.transfer.PrivateCraftingTeachingTransferHandler;
import com.minecolonies.coremod.compatibility.jei.transfer.PrivateSmeltingTeachingTransferHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private final List<JobBasedRecipeCategory<?>> categories = new ArrayList();
    private boolean recipesLoaded;
    private WeakReference<IJeiRuntime> weakRuntime;

    public JEIPlugin() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, CustomRecipesReloadedEvent.class, this::onCustomRecipesReloaded);
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("minecolonies");
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IModIdHelper modIdHelper = jeiHelpers.getModIdHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CompostRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FishermanRecipeCategory(guiHelper)});
        this.categories.clear();
        for (BuildingEntry building : IMinecoloniesAPI.getInstance().getBuildingRegistry()) {
            for (Supplier<IBuildingModule> producer : building.getModuleProducers()) {
                ICraftingBuildingModule crafting;
                IJob<?> job;
                IBuildingModule module = producer.get();
                if (module instanceof ICraftingBuildingModule && (job = (crafting = (ICraftingBuildingModule)module).getCraftingJob()) != null) {
                    this.registerCategory(registration, new GenericRecipeCategory(building, job, crafting, guiHelper, modIdHelper));
                }
                if (!(module instanceof AnimalHerdingModule)) continue;
                AnimalHerdingModule herding = (AnimalHerdingModule)module;
                this.registerCategory(registration, new HerderRecipeCategory(building, herding.getHerdingJob(), herding, guiHelper));
            }
        }
    }

    private void registerCategory(@NotNull IRecipeCategoryRegistration registration, @NotNull JobBasedRecipeCategory<?> category) {
        this.categories.add(category);
        registration.addRecipeCategories(new IRecipeCategory[]{category});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.blockHutComposter.m_5456_()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("com.minecolonies.coremod.jei." + ModJobs.COMPOSTER_ID.m_135815_())});
        if (!this.recipesLoaded && !Minecraft.m_91087_().m_91090_()) {
            return;
        }
        this.populateRecipes(this.buildVanillaRecipesMap(), (arg_0, arg_1) -> ((IRecipeRegistration)registration).addRecipes(arg_0, arg_1));
        this.recipesLoaded = true;
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.blockBarrel), new ResourceLocation[]{CompostRecipe.ID});
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.blockHutComposter), new ResourceLocation[]{CompostRecipe.ID});
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.blockHutFisherman), new ResourceLocation[]{ModJobs.FISHERMAN_ID});
        for (JobBasedRecipeCategory<?> category : this.categories) {
            registration.addRecipeCatalyst(category.getCatalyst(), new ResourceLocation[]{category.getUid()});
        }
    }

    public void registerRecipeTransferHandlers(@NotNull IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new PrivateCraftingTeachingTransferHandler(registration.getTransferHelper()), VanillaRecipeCategoryUid.CRAFTING);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new PrivateSmeltingTeachingTransferHandler(registration.getTransferHelper()), VanillaRecipeCategoryUid.FURNACE);
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
        new CraftingGuiHandler(this.categories).register(registration);
        new FurnaceCraftingGuiHandler(this.categories).register(registration);
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        this.weakRuntime = new WeakReference<IJeiRuntime>(jeiRuntime);
    }

    private Map<RecipeType<?>, List<IGenericRecipe>> buildVanillaRecipesMap() {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        ArrayList<IGenericRecipe> craftingRecipes = new ArrayList<IGenericRecipe>();
        for (Recipe recipe : recipeManager.m_44054_(RecipeType.f_44107_).values()) {
            if (!recipe.m_8004_(3, 3)) continue;
            this.tryAddingVanillaRecipe(craftingRecipes, recipe);
        }
        ArrayList<IGenericRecipe> smeltingRecipes = new ArrayList<IGenericRecipe>();
        for (Recipe recipe : recipeManager.m_44054_(RecipeType.f_44108_).values()) {
            this.tryAddingVanillaRecipe(smeltingRecipes, recipe);
        }
        return new ImmutableMap.Builder().put((Object)RecipeType.f_44107_, craftingRecipes).put((Object)RecipeType.f_44108_, smeltingRecipes).build();
    }

    private void tryAddingVanillaRecipe(@NotNull List<IGenericRecipe> recipes, @NotNull Recipe<?> recipe) {
        if (recipe.m_8043_().m_41619_()) {
            return;
        }
        try {
            IGenericRecipe genericRecipe = GenericRecipeUtils.create(recipe);
            if (genericRecipe.getInputs().isEmpty()) {
                return;
            }
            recipes.add(genericRecipe);
        }
        catch (Exception ex) {
            Log.getLogger().warn("Error evaluating recipe " + recipe.m_6423_() + "; ignoring.", (Throwable)ex);
        }
    }

    private void populateRecipes(@NotNull Map<RecipeType<?>, List<IGenericRecipe>> vanilla, @NotNull BiConsumer<Collection<?>, ResourceLocation> registrar) {
        registrar.accept(CompostRecipeCategory.findRecipes(), CompostRecipe.ID);
        registrar.accept(FishermanRecipeCategory.findRecipes(), ModJobs.FISHERMAN_ID);
        for (JobBasedRecipeCategory<?> category : this.categories) {
            try {
                registrar.accept(category.findRecipes(vanilla), category.getUid());
            }
            catch (Exception e) {
                Log.getLogger().error("Failed to process recipes for " + category.getTitle(), (Throwable)e);
            }
        }
    }

    private void onCustomRecipesReloaded(@NotNull CustomRecipesReloadedEvent event) {
        IJeiRuntime runtime;
        if (this.weakRuntime != null && !this.recipesLoaded && !this.categories.isEmpty() && (runtime = (IJeiRuntime)this.weakRuntime.get()) != null) {
            IRecipeManager jeiManager = runtime.getRecipeManager();
            this.populateRecipes(this.buildVanillaRecipesMap(), (list, uid) -> {
                for (Object recipe : list) {
                    jeiManager.addRecipe(recipe, uid);
                }
            });
        }
        this.recipesLoaded = true;
    }
}

