/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.modules.CraftingWorkerBuildingModule;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAICrafting<J extends AbstractJobCrafter<?, J>, B extends AbstractBuilding>
extends AbstractEntityAIInteract<J, B> {
    protected static final int HIT_DELAY = 10;
    public static final int PROGRESS_MULTIPLIER = 10;
    protected static final int MAX_LEVEL = 50;
    private static final int HITTING_TIME = 3;
    public IRequest<? extends PublicCrafting> currentRequest;
    protected IRecipeStorage currentRecipeStorage;
    private DamageSource playerDamageSource;

    protected int getActionRewardForCraftingSuccess() {
        return 1;
    }

    public AbstractEntityAICrafting(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, () -> AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, this::decide, 5), new AITarget((IAIState)AIWorkerState.QUERY_ITEMS, this::queryItems, 5), new AITarget((IAIState)AIWorkerState.GET_RECIPE, this::getRecipe, 5), new AITarget((IAIState)AIWorkerState.CRAFT, this::craft, 10));
        this.worker.m_21553_(true);
    }

    protected IAIState decide() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if (((AbstractJobCrafter)this.job).getTaskQueue().isEmpty()) {
            if (this.worker.getNavigation().m_26571_()) {
                if (((AbstractSchematicProvider)this.getOwnBuilding()).isInBuilding(this.worker.m_142538_())) {
                    this.worker.getNavigation().moveToRandomPos(10, 0.6, ((AbstractSchematicProvider)this.getOwnBuilding()).getCorners(), AbstractAdvancedPathNavigate.RestrictionType.XYZ);
                } else {
                    this.walkToBuilding();
                }
            }
            return AIWorkerState.IDLE;
        }
        if (((AbstractJobCrafter)this.job).getCurrentTask() == null) {
            return AIWorkerState.IDLE;
        }
        if (this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        if (((AbstractJobCrafter)this.job).getActionsDone() >= this.getActionsDoneUntilDumping()) {
            return this.getState();
        }
        return this.getNextCraftingState();
    }

    protected IAIState getNextCraftingState() {
        if (((AbstractJobCrafter)this.job).getCurrentTask() == null) {
            return this.getState();
        }
        if (this.currentRequest != null && this.currentRecipeStorage != null) {
            return AIWorkerState.QUERY_ITEMS;
        }
        return AIWorkerState.GET_RECIPE;
    }

    protected IAIState getRecipe() {
        IRequest currentTask = ((AbstractJobCrafter)this.job).getCurrentTask();
        if (currentTask == null) {
            return AIWorkerState.START_WORKING;
        }
        ICraftingBuildingModule module = ((AbstractBuilding)this.getOwnBuilding()).getCraftingModuleForRecipe(((PublicCrafting)currentTask.getRequest()).getRecipeID());
        if (module == null) {
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            return AIWorkerState.START_WORKING;
        }
        this.currentRecipeStorage = module.getFirstFulfillableRecipe(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, ((PublicCrafting)currentTask.getRequest()).getStack()), 1, false);
        if (this.currentRecipeStorage == null) {
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            return AIWorkerState.START_WORKING;
        }
        this.currentRequest = currentTask;
        ((AbstractJobCrafter)this.job).setMaxCraftingCount(this.currentRequest.getRequest().getCount());
        int currentCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.currentRecipeStorage.getPrimaryOutput()));
        int inProgressCount = this.getExtendedCount(this.currentRecipeStorage.getPrimaryOutput());
        int countPerIteration = this.currentRecipeStorage.getPrimaryOutput().m_41613_();
        int doneOpsCount = currentCount / countPerIteration;
        int progressOpsCount = inProgressCount / countPerIteration;
        int remainingOpsCount = this.currentRequest.getRequest().getCount() - doneOpsCount - progressOpsCount;
        List<ItemStorage> input = this.currentRecipeStorage.getCleanedInput();
        for (ItemStorage inputStorage : input) {
            ItemStack container = inputStorage.getItem().getContainerItem(inputStorage.getItemStack());
            int remaining = !this.currentRecipeStorage.getCraftingToolsAndSecondaryOutputs().isEmpty() && ItemStackUtils.compareItemStackListIgnoreStackSize(this.currentRecipeStorage.getCraftingToolsAndSecondaryOutputs(), inputStorage.getItemStack(), false, true) ? inputStorage.getAmount() : (ItemStackUtils.isEmpty(container) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(inputStorage.getItemStack(), container, false, true) ? inputStorage.getAmount() : inputStorage.getAmount() * remainingOpsCount);
            if (InventoryUtils.getCountFromBuilding(this.getOwnBuilding(), itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, inputStorage.getItemStack(), false, true)) + InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, inputStorage.getItemStack(), false, true)) + this.getExtendedCount(inputStorage.getItemStack()) >= remaining) continue;
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            return AIWorkerState.START_WORKING;
        }
        ((AbstractJobCrafter)this.job).setCraftCounter(doneOpsCount);
        return AIWorkerState.QUERY_ITEMS;
    }

    protected int getExtendedCount(ItemStack stack) {
        return 0;
    }

    @Override
    public IAIState getStateAfterPickUp() {
        return AIWorkerState.GET_RECIPE;
    }

    private IAIState queryItems() {
        if (this.currentRecipeStorage == null) {
            return AIWorkerState.START_WORKING;
        }
        return this.checkForItems(this.currentRecipeStorage);
    }

    protected IAIState checkForItems(@NotNull IRecipeStorage storage) {
        int inProgressCount = this.getExtendedCount(this.currentRecipeStorage.getPrimaryOutput());
        int countPerIteration = this.currentRecipeStorage.getPrimaryOutput().m_41613_();
        int progressOpsCount = inProgressCount / Math.max(countPerIteration, 1);
        List<ItemStorage> input = storage.getCleanedInput();
        for (ItemStorage inputStorage : input) {
            Predicate<ItemStack> predicate = stack -> ItemStackUtils.isEmpty(stack) == false && new Stack((ItemStack)stack, false).matches(inputStorage.getItemStack());
            int invCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), predicate);
            ItemStack container = inputStorage.getItem().getContainerItem(inputStorage.getItemStack());
            int remaining = !this.currentRecipeStorage.getCraftingToolsAndSecondaryOutputs().isEmpty() && ItemStackUtils.compareItemStackListIgnoreStackSize(this.currentRecipeStorage.getCraftingToolsAndSecondaryOutputs(), inputStorage.getItemStack(), false, true) ? inputStorage.getAmount() : (ItemStackUtils.isEmpty(container) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(inputStorage.getItemStack(), container, false, true) ? inputStorage.getAmount() : inputStorage.getAmount() * Math.max(((AbstractJobCrafter)this.job).getMaxCraftingCount(), 1));
            if (invCount > 0 && invCount + (((AbstractJobCrafter)this.job).getCraftCounter() + progressOpsCount) * inputStorage.getAmount() >= remaining) continue;
            if (InventoryUtils.hasItemInProvider(this.getOwnBuilding(), predicate)) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(predicate, remaining);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.currentRecipeStorage = null;
            this.currentRequest = null;
            return AIWorkerState.GET_RECIPE;
        }
        return AIWorkerState.CRAFT;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected IAIState craft() {
        if (this.currentRecipeStorage == null) return AIWorkerState.START_WORKING;
        if (((AbstractJobCrafter)this.job).getCurrentTask() == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.currentRequest == null && ((AbstractJobCrafter)this.job).getCurrentTask() != null) {
            return AIWorkerState.GET_RECIPE;
        }
        if (this.walkToBuilding()) {
            return this.getState();
        }
        ((AbstractJobCrafter)this.job).setProgress(((AbstractJobCrafter)this.job).getProgress() + 1);
        this.worker.m_21008_(InteractionHand.MAIN_HAND, this.currentRecipeStorage.getCleanedInput().get(this.worker.m_21187_().nextInt(this.currentRecipeStorage.getCleanedInput().size())).getItemStack().m_41777_());
        this.worker.m_21008_(InteractionHand.OFF_HAND, this.currentRecipeStorage.getPrimaryOutput().m_41777_());
        this.worker.getCitizenItemHandler().hitBlockWithToolInHand(((AbstractSchematicProvider)this.getOwnBuilding()).getPosition());
        this.currentRequest = ((AbstractJobCrafter)this.job).getCurrentTask();
        if (this.currentRequest != null && (this.currentRequest.getState() == RequestState.CANCELLED || this.currentRequest.getState() == RequestState.FAILED)) {
            this.currentRequest = null;
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            this.currentRecipeStorage = null;
            return AIWorkerState.START_WORKING;
        }
        if (((AbstractJobCrafter)this.job).getProgress() < this.getRequiredProgressForMakingRawMaterial()) return this.getState();
        IAIState check = this.checkForItems(this.currentRecipeStorage);
        if (check != AIWorkerState.CRAFT) {
            this.currentRequest = null;
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.incrementActionsDoneAndDecSaturation();
            this.resetValues();
            return AIWorkerState.START_WORKING;
        }
        if (!this.currentRecipeStorage.fullfillRecipe(this.getLootContext(), (List<IItemHandler>)ImmutableList.of((Object)this.worker.getItemHandlerCitizen()))) {
            this.currentRequest = null;
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.resetValues();
            return AIWorkerState.START_WORKING;
        }
        this.currentRequest.addDelivery(this.currentRecipeStorage.getPrimaryOutput());
        ((AbstractJobCrafter)this.job).setCraftCounter(((AbstractJobCrafter)this.job).getCraftCounter() + 1);
        if (((AbstractJobCrafter)this.job).getCraftCounter() < ((AbstractJobCrafter)this.job).getMaxCraftingCount()) {
            ((AbstractJobCrafter)this.job).setProgress(0);
            return AIWorkerState.GET_RECIPE;
        }
        this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
        ICraftingBuildingModule module = ((AbstractBuilding)this.getOwnBuilding()).getCraftingModuleForRecipe(this.currentRecipeStorage.getToken());
        if (module != null) {
            module.improveRecipe(this.currentRecipeStorage, ((AbstractJobCrafter)this.job).getCraftCounter(), this.worker.getCitizenData());
        }
        this.currentRecipeStorage = null;
        this.resetValues();
        if (!this.inventoryNeedsDump()) return AIWorkerState.START_WORKING;
        if (((AbstractJobCrafter)this.job).getMaxCraftingCount() != 0) return AIWorkerState.START_WORKING;
        if (((AbstractJobCrafter)this.job).getProgress() != 0) return AIWorkerState.START_WORKING;
        if (((AbstractJobCrafter)this.job).getCraftCounter() != 0) return AIWorkerState.START_WORKING;
        if (this.currentRequest == null) return AIWorkerState.START_WORKING;
        ((AbstractJobCrafter)this.job).finishRequest(true);
        this.worker.getCitizenExperienceHandler().addExperience((double)this.currentRequest.getRequest().getCount() / 2.0);
        return AIWorkerState.START_WORKING;
    }

    public void resetValues() {
        ((AbstractJobCrafter)this.job).setMaxCraftingCount(0);
        ((AbstractJobCrafter)this.job).setProgress(0);
        ((AbstractJobCrafter)this.job).setCraftCounter(0);
        this.worker.m_21008_(InteractionHand.MAIN_HAND, ItemStackUtils.EMPTY);
        this.worker.m_21008_(InteractionHand.OFF_HAND, ItemStackUtils.EMPTY);
    }

    @Override
    public IAIState afterDump() {
        if (((AbstractJobCrafter)this.job).getMaxCraftingCount() == 0 && ((AbstractJobCrafter)this.job).getProgress() == 0 && ((AbstractJobCrafter)this.job).getCraftCounter() == 0 && this.currentRequest != null) {
            if (this.currentRequest.getState() == RequestState.IN_PROGRESS) {
                ((AbstractJobCrafter)this.job).finishRequest(true);
            }
            this.currentRequest = null;
        }
        this.resetValues();
        return super.afterDump();
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    private int getRequiredProgressForMakingRawMaterial() {
        int jobModifier = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(((CraftingWorkerBuildingModule)this.getModuleForJob()).getCraftSpeedSkill()) / 2;
        return 10 / Math.min(jobModifier + 1, 50) * 3;
    }

    @Override
    public boolean isAfterDumpPickupAllowed() {
        return this.currentRequest == null;
    }

    protected LootContext getLootContext() {
        return this.getLootContext(false);
    }

    protected LootContext getLootContext(boolean includeKiller) {
        if (this.playerDamageSource == null) {
            FakePlayer fp = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.world));
            this.playerDamageSource = DamageSource.m_19344_((Player)fp);
        }
        LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.world).m_78972_(LootContextParams.f_81460_, (Object)this.worker.m_20182_()).m_78972_(LootContextParams.f_81455_, (Object)this.worker).m_78972_(LootContextParams.f_81463_, (Object)this.worker.m_21205_()).m_78977_(this.worker.m_21187_()).m_78963_((float)this.getEffectiveSkillLevel(this.getPrimarySkillLevel()));
        if (includeKiller) {
            builder = builder.m_78972_(LootContextParams.f_81457_, (Object)this.playerDamageSource).m_78972_(LootContextParams.f_81458_, (Object)this.playerDamageSource.m_7639_()).m_78972_(LootContextParams.f_81459_, (Object)this.playerDamageSource.m_7640_());
        }
        return builder.m_78975_(RecipeStorage.recipeLootParameters);
    }
}

