/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding.pathjobs;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.entity.pathfinding.TreePathResult;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.entity.ai.citizen.lumberjack.Tree;
import com.minecolonies.coremod.entity.pathfinding.MNode;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class PathJobFindTree
extends AbstractPathJob {
    private static final double TIE_BREAKER = 0.951;
    private static final Vec3i AREA_SHRINK = new Vec3i(-1, 0, -1);
    private final BlockPos hutLocation;
    private final List<ItemStorage> excludedTrees;
    private final IColony colony;
    private final BlockPos boxCenter;
    private final int dyntreesize;

    public PathJobFindTree(Level world, @NotNull BlockPos start, BlockPos home, int range, List<ItemStorage> treesToCut, int dyntreesize, IColony colony, LivingEntity entity) {
        super(world, start, start, range, new TreePathResult(), entity);
        this.excludedTrees = treesToCut;
        this.hutLocation = home;
        this.colony = colony;
        this.boxCenter = null;
        this.dyntreesize = dyntreesize;
    }

    public PathJobFindTree(Level world, @NotNull BlockPos start, BlockPos home, BlockPos startRestriction, BlockPos endRestriction, BlockPos furthestRestriction, List<ItemStorage> excludedTrees, int dyntreesize, IColony colony, LivingEntity entity) {
        super(world, start, startRestriction, endRestriction, (int)Math.sqrt((double)BlockPosUtil.getDistanceSquared2D(home, furthestRestriction) * 1.5), AREA_SHRINK, false, new TreePathResult(), entity, AbstractAdvancedPathNavigate.RestrictionType.XZ);
        this.excludedTrees = excludedTrees;
        this.hutLocation = home;
        this.colony = colony;
        this.dyntreesize = dyntreesize;
        BlockPos size = startRestriction.m_141950_((Vec3i)endRestriction);
        this.boxCenter = endRestriction.m_142082_(size.m_123341_() / 2, size.m_123342_() / 2, size.m_123343_() / 2);
    }

    @Override
    @NotNull
    public TreePathResult getResult() {
        return (TreePathResult)super.getResult();
    }

    @Override
    protected double computeHeuristic(@NotNull BlockPos pos) {
        return this.boxCenter == null ? pos.m_123331_((Vec3i)this.hutLocation) * 0.951 : (double)BlockPosUtil.getDistanceSquared2D(pos, this.boxCenter);
    }

    @Override
    protected boolean isAtDestination(@NotNull MNode n) {
        return n.parent != null && this.isNearTree(n);
    }

    private boolean isNearTree(@NotNull MNode n) {
        if (n.pos.m_123341_() == n.parent.pos.m_123341_()) {
            int dz = n.pos.m_123343_() > n.parent.pos.m_123343_() ? 1 : -1;
            return this.isTree(n.pos.m_142082_(0, 0, dz)) || this.isTree(n.pos.m_142082_(-1, 0, 0)) || this.isTree(n.pos.m_142082_(1, 0, 0));
        }
        int dx = n.pos.m_123341_() > n.parent.pos.m_123341_() ? 1 : -1;
        return this.isTree(n.pos.m_142082_(dx, 0, 0)) || this.isTree(n.pos.m_142082_(0, 0, -1)) || this.isTree(n.pos.m_142082_(0, 0, 1));
    }

    private boolean isTree(BlockPos pos) {
        if (Tree.checkTree(this.world, pos, this.excludedTrees, this.dyntreesize) && Tree.checkIfInColonyAndNotInBuilding(pos, this.colony, this.world)) {
            this.getResult().treeLocation = pos;
            return true;
        }
        return false;
    }

    @Override
    protected double getNodeResultScore(MNode n) {
        return 0.0;
    }

    @Override
    protected boolean isPassable(@NotNull BlockState block, BlockPos pos, MNode parent) {
        return super.isPassable(block, pos, parent) || block.m_60620_((Tag)BlockTags.f_13035_) && this.isInRestrictedArea(pos) || Compatibility.isDynamicTrunkShell(block.m_60734_());
    }
}

