/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding.pathjobs;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.pathfinding.PathingOptions;
import com.minecolonies.api.entity.pathfinding.PathingStuckHandler;
import com.minecolonies.api.entity.pathfinding.SurfaceType;
import com.minecolonies.coremod.colony.managers.RaidManager;
import com.minecolonies.coremod.entity.pathfinding.MNode;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class PathJobRaiderPathing
extends AbstractPathJob {
    private final double THROUGH_BLOCK_COST = 30.0;
    private final List<IBuilding> buildings;
    private final BlockPos direction;
    private double addCost = 1.0;

    public PathJobRaiderPathing(List<IBuilding> buildings, Level world, @NotNull BlockPos start, BlockPos targetSpawnPoint, int range) {
        super(world, start, targetSpawnPoint, range, null);
        this.buildings = buildings;
        this.direction = targetSpawnPoint;
        this.setPathingOptions(new PathingOptions().withJumpCost(1.0).withStartSwimCost(1.0).withSwimCost(1.0).withCanSwim(true).withCanEnterDoors(true));
    }

    @Override
    protected double computeHeuristic(BlockPos pos) {
        return Math.sqrt(this.direction.m_123331_((Vec3i)pos));
    }

    @Override
    protected boolean isAtDestination(MNode n) {
        if (this.start.m_123331_((Vec3i)n.pos) < 2500.0) {
            return false;
        }
        return this.direction.m_123331_((Vec3i)n.pos) < 2500.0 && RaidManager.isValidSpawnPoint(this.buildings, n.pos);
    }

    @Override
    protected double getNodeResultScore(MNode n) {
        return Math.sqrt(this.direction.m_123331_((Vec3i)n.pos));
    }

    @Override
    protected boolean isPassable(BlockPos pos, boolean head, MNode currentnode) {
        return true;
    }

    @Override
    protected boolean onLadderGoingDown(@NotNull MNode currentNode, @NotNull BlockPos dPos) {
        return !currentNode.isSwimming();
    }

    @Override
    protected boolean onLadderGoingUp(@NotNull MNode currentNode, @NotNull BlockPos dPos) {
        if (SurfaceType.getSurfaceType((BlockGetter)this.world, this.world.m_8055_(currentNode.pos), currentNode.pos) == SurfaceType.WALKABLE) {
            return true;
        }
        if (dPos.m_123342_() >= 0 || dPos.m_123341_() != 0 || dPos.m_123343_() != 0) {
            if (currentNode.isLadder()) {
                return true;
            }
            for (Direction dir : PathingStuckHandler.HORIZONTAL_DIRS) {
                BlockState toPlace = (BlockState)Blocks.f_50155_.m_49966_().m_61124_((Property)LadderBlock.f_54337_, (Comparable)dir.m_122424_());
                if (!this.world.m_8055_(currentNode.pos.m_142300_(dir)).m_60767_().m_76333_() || !Blocks.f_50155_.m_7898_(toPlace, this.world, currentNode.pos)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected int getGroundHeight(MNode parent, @NotNull BlockPos pos) {
        int height = super.getGroundHeight(parent, pos);
        if (height != pos.m_123342_()) {
            this.addCost = 0.5;
        }
        if (parent.pos.m_123341_() - pos.m_123341_() == 0 && parent.pos.m_123343_() - pos.m_123343_() == 0 || Math.abs(height - pos.m_123342_()) > 1 && SurfaceType.getSurfaceType((BlockGetter)this.world, this.world.m_8055_(pos.m_7495_()), pos.m_7495_()) == SurfaceType.WALKABLE) {
            this.addCost = 3.5;
            return pos.m_123342_();
        }
        return height;
    }

    @Override
    protected double computeCost(@NotNull BlockPos dPos, boolean isSwimming, boolean onPath, boolean onRails, boolean railsExit, boolean swimStart, boolean corner, BlockState state, BlockPos blockPos) {
        double modifier = this.addCost;
        this.addCost = 1.0;
        if (!super.isPassable(blockPos, false, null)) {
            modifier *= 30.0;
        }
        if (!corner && SurfaceType.getSurfaceType((BlockGetter)this.world, this.world.m_8055_(blockPos.m_7495_()), blockPos.m_7495_()) != SurfaceType.WALKABLE) {
            modifier *= 30.0;
        }
        return super.computeCost(dPos, isSwimming, onPath, onRails, railsExit, swimStart, corner, state, blockPos) * modifier;
    }
}

