/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.google.common.collect.ImmutableMap;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.sounds.ModSoundEvents;
import com.minecolonies.coremod.client.render.worldevent.WorldEventContext;
import com.minecolonies.coremod.colony.crafting.CustomRecipe;
import com.minecolonies.coremod.colony.crafting.CustomRecipeManager;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static final String MOB_SOUND_EVENT_PREFIX = "mob.";
    private static final Lazy<Map<String, BuildingEntry>> crafterToBuilding = Lazy.of(ClientEventHandler::buildCrafterToBuildingMap);

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderWorldLastEvent(@NotNull RenderLevelLastEvent event) {
        WorldEventContext.INSTANCE.renderWorldLastEvent(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlaySoundEvent(PlaySoundEvent event) {
        if (event.getSound() == null) {
            return;
        }
        if (event.getSound().m_7904_().m_135827_().equals("minecolonies") && !((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getClient().citizenVoices.get()).booleanValue()) {
            String path = event.getSound().m_7904_().m_135815_();
            if (!path.startsWith(MOB_SOUND_EVENT_PREFIX)) {
                return;
            }
            int secondDotPos = path.indexOf(46, MOB_SOUND_EVENT_PREFIX.length());
            if (secondDotPos == -1) {
                return;
            }
            String mobName = path.substring(MOB_SOUND_EVENT_PREFIX.length(), secondDotPos);
            if (ModSoundEvents.CITIZEN_SOUND_EVENTS.containsKey(mobName)) {
                event.setSound(null);
            }
        }
    }

    @SubscribeEvent
    public static void onItemTooltipEvent(ItemTooltipEvent event) {
        BlockItem blockItem;
        if (event.getPlayer() == null) {
            return;
        }
        IColony colony = IMinecoloniesAPI.getInstance().getColonyManager().getIColony(event.getPlayer().f_19853_, event.getPlayer().m_142538_());
        if (colony == null) {
            colony = IMinecoloniesAPI.getInstance().getColonyManager().getIColonyByOwner(event.getPlayer().f_19853_, event.getPlayer());
        }
        ClientEventHandler.handleCrafterRecipeTooltips(colony, event.getToolTip(), event.getItemStack().m_41720_());
        if (event.getItemStack().m_41720_() instanceof BlockItem && (blockItem = (BlockItem)event.getItemStack().m_41720_()).m_40614_() instanceof AbstractBlockHut) {
            ClientEventHandler.handleHutBlockResearchUnlocks(colony, event.getToolTip(), blockItem.m_40614_());
        }
    }

    private static void handleCrafterRecipeTooltips(@Nullable IColony colony, List<Component> toolTip, Item item) {
        List<CustomRecipe> recipes = CustomRecipeManager.getInstance().getRecipeByOutput(item);
        if (recipes.isEmpty()) {
            return;
        }
        for (CustomRecipe rec : recipes) {
            Set<Object> researches;
            BuildingEntry craftingBuilding;
            if (!rec.getShowTooltip() || rec.getCrafter().length() < 2 || (craftingBuilding = (BuildingEntry)((Object)((Map)crafterToBuilding.get()).get(rec.getCrafter()))) == null) continue;
            Component craftingBuildingName = ClientEventHandler.getFullBuildingName(craftingBuilding);
            if (rec.getMinBuildingLevel() > 0) {
                String schematicName = craftingBuilding.getRegistryName().m_135815_();
                TranslatableComponent reqLevelText = new TranslatableComponent("com.minecolonies.coremod.item.buildlevel.gui", new Object[]{craftingBuildingName, rec.getMinBuildingLevel()});
                if (colony != null && colony.hasBuilding(schematicName, rec.getMinBuildingLevel(), true)) {
                    reqLevelText.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA));
                } else {
                    reqLevelText.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
                }
                toolTip.add((Component)reqLevelText);
            } else {
                MutableComponent reqBuildingTxt = new TranslatableComponent("com.minecolonies.coremod.item.available.gui", new Object[]{craftingBuildingName}).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GRAY));
                toolTip.add((Component)reqBuildingTxt);
            }
            if (rec.getRequiredResearchId() == null) continue;
            if (IMinecoloniesAPI.getInstance().getGlobalResearchTree().hasResearch(rec.getRequiredResearchId())) {
                researches = new HashSet<IGlobalResearch>();
                researches.add(IMinecoloniesAPI.getInstance().getGlobalResearchTree().getResearch(rec.getRequiredResearchId()));
            } else {
                researches = IMinecoloniesAPI.getInstance().getGlobalResearchTree().getResearchForEffect(rec.getRequiredResearchId());
            }
            if (researches == null) continue;
            ChatFormatting researchFormat = colony != null && (colony.getResearchManager().getResearchTree().hasCompletedResearch(rec.getRequiredResearchId()) || colony.getResearchManager().getResearchEffects().getEffectStrength(rec.getRequiredResearchId()) > 0.0) ? ChatFormatting.AQUA : ChatFormatting.RED;
            for (IGlobalResearch iGlobalResearch : researches) {
                toolTip.add((Component)new TranslatableComponent("com.minecolonies.coremod.item.requiresresearch.gui", new Object[]{iGlobalResearch.getName()}).m_6270_(Style.f_131099_.m_131140_(researchFormat)));
            }
        }
    }

    private static Component getFullBuildingName(@NotNull BuildingEntry building) {
        String namespace = building.getBuildingBlock().getRegistryName().m_135827_();
        String modName = ModList.get().getModContainerById(namespace).map(m -> m.getModInfo().getDisplayName()).orElse(namespace);
        MutableComponent buildingName = building.getBuildingBlock().m_49954_();
        return new TextComponent(modName + " ").m_7220_((Component)buildingName);
    }

    private static Map<String, BuildingEntry> buildCrafterToBuildingMap() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BuildingEntry building : IMinecoloniesAPI.getInstance().getBuildingRegistry()) {
            building.getModuleProducers().stream().map(Supplier::get).filter(m -> m instanceof ICraftingBuildingModule).map(m -> (ICraftingBuildingModule)m).filter(m -> m.getCraftingJob() != null).forEach(crafting -> builder.put((Object)crafting.getCustomRecipeKey(), (Object)building));
        }
        return builder.build();
    }

    private static void handleHutBlockResearchUnlocks(IColony colony, List<Component> tooltip, Block block) {
        if (colony == null) {
            return;
        }
        ResourceLocation effectId = colony.getResearchManager().getResearchEffectIdFrom(block);
        if (colony.getResearchManager().getResearchEffects().getEffectStrength(effectId) > 0.0) {
            return;
        }
        if (MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().getResearchForEffect(effectId) != null) {
            tooltip.add((Component)new TranslatableComponent("com.minecolonies.coremod.research.item1", new Object[]{block.m_49954_()}));
            tooltip.add((Component)new TranslatableComponent("com.minecolonies.coremod.research.item2", new Object[]{block.m_49954_()}));
        }
    }

    @SubscribeEvent
    public static void onDebugOverlay(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92063_) {
            ClientLevel world = mc.f_91073_;
            LocalPlayer player = mc.f_91074_;
            BlockPos pos = new BlockPos(player.m_20182_());
            IColony colony = IColonyManager.getInstance().getIColony((Level)world, pos);
            if (colony == null) {
                if (IColonyManager.getInstance().isFarEnoughFromColonies((Level)world, pos)) {
                    event.getLeft().add(new TranslatableComponent("com.minecolonies.coremod.gui.debugscreen.noclosecolony").getString());
                    return;
                }
                colony = IColonyManager.getInstance().getClosestIColony((Level)world, pos);
                if (colony == null) {
                    return;
                }
                event.getLeft().add(new TranslatableComponent("com.minecolonies.coremod.gui.debugscreen.nextcolony", new Object[]{(int)Math.sqrt(colony.getDistanceSquared(pos)), IColonyManager.getInstance().getMinimumDistanceBetweenTownHalls()}).getString());
                return;
            }
            event.getLeft().add(colony.getName() + " : " + new TranslatableComponent("com.minecolonies.coremod.gui.debugscreen.blocksfromcenter", new Object[]{(int)Math.sqrt(colony.getDistanceSquared(pos))}).getString());
        }
    }
}

