/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.crafting.ItemStorage;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomRecipeProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;

    public CustomRecipeProvider(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void m_6865_(HashCache cache) throws IOException {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        this.registerRecipes(recipe -> {
            if (!set.add(recipe.m_6445_())) {
                throw new IllegalStateException("Duplicate recipe " + recipe.m_6445_());
            }
            CustomRecipeProvider.saveRecipe(cache, recipe.m_125966_(), path.resolve("data/" + recipe.m_6445_().m_135827_() + "/crafterrecipes/" + recipe.m_6445_().m_135815_() + ".json"));
        });
    }

    private static void saveRecipe(HashCache cache, JsonObject jsonObject, Path recipeJson) {
        try {
            String json = GSON.toJson((JsonElement)jsonObject);
            String hash = f_123918_.hashUnencodedChars((CharSequence)json).toString();
            if (!Objects.equals(cache.m_123938_(recipeJson), hash) || !Files.exists(recipeJson, new LinkOption[0])) {
                Files.createDirectories(recipeJson.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(recipeJson, new OpenOption[0]);){
                    bufferedwriter.write(json);
                }
            }
            cache.m_123940_(recipeJson, hash);
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't save recipe {}", (Object)recipeJson, (Object)ioexception);
        }
    }

    protected abstract void registerRecipes(Consumer<FinishedRecipe> var1);

    public static class CustomRecipeBuilder {
        private final JsonObject json = new JsonObject();
        private final ResourceLocation id;
        private Block intermediate = Blocks.f_50016_;

        private CustomRecipeBuilder(String crafter, String id) {
            this.json.addProperty("type", "recipe");
            this.json.addProperty("crafter", crafter);
            this.id = new ResourceLocation("minecolonies", crafter + "/" + id);
        }

        @NotNull
        public static CustomRecipeBuilder create(String crafter, String id) {
            return new CustomRecipeBuilder(crafter, id);
        }

        @NotNull
        public CustomRecipeBuilder inputs(@NotNull List<ItemStorage> inputs) {
            this.json.add("inputs", (JsonElement)this.storageAsJson(inputs));
            return this;
        }

        @NotNull
        public CustomRecipeBuilder result(@NotNull ItemStack result) {
            this.json.addProperty("result", result.m_41720_().getRegistryName().toString());
            if (result.m_41613_() != 1) {
                this.json.addProperty("count", (Number)result.m_41613_());
            }
            return this;
        }

        @NotNull
        public CustomRecipeBuilder lootTable(@NotNull ResourceLocation lootTable) {
            this.json.addProperty("loot-table", lootTable.toString());
            return this;
        }

        @NotNull
        public CustomRecipeBuilder secondaryOutputs(@NotNull List<ItemStack> secondary) {
            this.json.add("additional-output", (JsonElement)this.stackAsJson(secondary));
            return this;
        }

        @NotNull
        public CustomRecipeBuilder alternateOutputs(@NotNull List<ItemStack> alternates) {
            this.json.add("alternate-output", (JsonElement)this.stackAsJson(alternates));
            return this;
        }

        @NotNull
        public CustomRecipeBuilder intermediate(@NotNull Block intermediate) {
            this.intermediate = intermediate;
            return this;
        }

        @NotNull
        public CustomRecipeBuilder minResearchId(@NotNull ResourceLocation researchId) {
            this.json.addProperty("research-id", researchId.toString());
            return this;
        }

        @NotNull
        public CustomRecipeBuilder maxResearchId(@NotNull ResourceLocation researchId) {
            this.json.addProperty("not-research-id", researchId.toString());
            return this;
        }

        @NotNull
        public CustomRecipeBuilder minBuildingLevel(int level) {
            this.json.addProperty("min-building-level", (Number)level);
            return this;
        }

        @NotNull
        public CustomRecipeBuilder maxBuildingLevel(int level) {
            this.json.addProperty("max-building-level", (Number)level);
            return this;
        }

        @NotNull
        public CustomRecipeBuilder mustExist(boolean value) {
            this.json.addProperty("must-exist", Boolean.valueOf(value));
            return this;
        }

        @NotNull
        public CustomRecipeBuilder showTooltip(boolean value) {
            this.json.addProperty("show-tooltip", Boolean.valueOf(value));
            return this;
        }

        public void build(@NotNull Consumer<FinishedRecipe> consumer) {
            this.json.addProperty("intermediate", this.intermediate.getRegistryName().toString());
            consumer.accept(new Result(this.json, this.id));
        }

        @NotNull
        private JsonArray stackAsJson(List<ItemStack> itemStacks) {
            JsonArray jsonItemStacks = new JsonArray();
            for (ItemStack itemStack : itemStacks) {
                JsonObject jsonItemStack = new JsonObject();
                Object name = itemStack.m_41720_().getRegistryName().toString();
                if (itemStack.m_41782_() && !itemStack.m_41763_()) {
                    name = (String)name + itemStack.m_41783_().toString();
                }
                jsonItemStack.addProperty("item", (String)name);
                if (itemStack.m_41613_() != 1) {
                    jsonItemStack.addProperty("count", (Number)itemStack.m_41613_());
                }
                jsonItemStacks.add((JsonElement)jsonItemStack);
            }
            return jsonItemStacks;
        }

        @NotNull
        private JsonArray storageAsJson(List<ItemStorage> itemStorages) {
            JsonArray jsonItemStorages = new JsonArray();
            for (ItemStorage itemStorage : itemStorages) {
                ItemStack stack = itemStorage.getItemStack();
                JsonObject jsonItemStorage = new JsonObject();
                Object name = stack.m_41720_().getRegistryName().toString();
                if (stack.m_41782_() && !stack.m_41763_()) {
                    name = (String)name + stack.m_41783_().toString();
                }
                jsonItemStorage.addProperty("item", (String)name);
                if (itemStorage.ignoreNBT()) {
                    jsonItemStorage.addProperty("matchType", "ignore");
                }
                if (itemStorage.getAmount() != 1) {
                    jsonItemStorage.addProperty("count", (Number)itemStorage.getAmount());
                }
                jsonItemStorages.add((JsonElement)jsonItemStorage);
            }
            return jsonItemStorages;
        }

        private static class Result
        implements FinishedRecipe {
            final JsonObject json;
            final ResourceLocation id;

            public Result(JsonObject json, ResourceLocation id) {
                this.json = json;
                this.id = id;
            }

            @NotNull
            public JsonObject m_125966_() {
                return this.json;
            }

            @NotNull
            public ResourceLocation m_6445_() {
                return this.id;
            }

            public void m_7917_(@NotNull JsonObject json) {
            }

            public RecipeSerializer<?> m_6637_() {
                return null;
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        }
    }
}

