/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.items.AbstractItemScroll;
import com.minecolonies.coremod.network.messages.client.VanillaParticleMessage;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemScrollBuff
extends AbstractItemScroll {
    public ItemScrollBuff(Item.Properties properties) {
        super("scroll_buff", properties);
    }

    @Override
    protected ItemStack onItemUseSuccess(ItemStack itemStack, Level world, ServerPlayer player) {
        if (world.f_46441_.nextInt(8) > 0) {
            for (LivingEntity entity : world.m_45976_(EntityCitizen.class, player.m_142469_().m_82377_(15.0, 2.0, 15.0))) {
                this.addRegenerationWithParticles(entity);
            }
            this.addRegenerationWithParticles((LivingEntity)player);
            Network.getNetwork().sendToPlayer(new VanillaParticleMessage(player.m_20185_(), player.m_20186_(), player.m_20189_(), ParticleTypes.f_123750_), player);
            SoundUtils.playSoundForPlayer(player, SoundEvents.f_12275_, 0.2f, 1.0f);
        } else {
            player.m_5661_((Component)new TranslatableComponent("minecolonies.scroll.failed" + (world.f_46441_.nextInt(10) + 1)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200));
            SoundUtils.playSoundForPlayer(player, SoundEvents.f_12513_, 0.04f, 1.0f);
        }
        itemStack.m_41774_(1);
        return itemStack;
    }

    private void addRegenerationWithParticles(LivingEntity entity) {
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 1200));
        Network.getNetwork().sendToTrackingEntity(new VanillaParticleMessage(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ParticleTypes.f_123750_), (Entity)entity);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        MutableComponent guiHint = LanguageHandler.buildChatComponent((String)"item.minecolonies.scroll_buff.tip", (Object[])new Object[0]);
        guiHint.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN));
        tooltip.add((Component)guiHint);
    }

    @Override
    protected boolean needsColony() {
        return false;
    }
}

