/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.ldtteam.structurize.management.Structures;
import com.minecolonies.api.network.IMessage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyStylesMessage
implements IMessage {
    private Map<String, String> md5Map;

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.md5Map = ColonyStylesMessage.readMD5MapFromByteBuf(buf);
    }

    @NotNull
    private static Map<String, String> readMD5MapFromByteBuf(@NotNull FriendlyByteBuf buf) {
        @NotNull HashMap<String, String> map = new HashMap<String, String>();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            String filename = buf.m_130136_(Short.MAX_VALUE);
            String md5 = buf.m_130136_(Short.MAX_VALUE);
            map.put(filename, md5);
        }
        return map;
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        ColonyStylesMessage.writeMD5MapToByteBuf(buf);
    }

    private static void writeMD5MapToByteBuf(@NotNull FriendlyByteBuf buf) {
        Map md5s = Structures.getMD5s();
        buf.writeInt(md5s.size());
        for (Map.Entry entry : md5s.entrySet()) {
            buf.m_130070_((String)entry.getKey());
            buf.m_130070_((String)entry.getValue());
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        Structures.setMD5s(this.md5Map);
    }
}

