/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.util.ChunkCapData;
import com.minecolonies.coremod.util.ChunkClientDataHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateChunkCapabilityMessage
implements IMessage {
    private ChunkCapData chunkCapData;

    public UpdateChunkCapabilityMessage() {
    }

    public UpdateChunkCapabilityMessage(@NotNull IColonyTagCapability tagCapability, int x, int z) {
        this.chunkCapData = new ChunkCapData(x, z, tagCapability.getOwningColony(), tagCapability.getAllCloseColonies());
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.chunkCapData = ChunkCapData.fromBytes(buf);
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        this.chunkCapData.toBytes(buf);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (!WorldUtil.isChunkLoaded((LevelAccessor)world, new ChunkPos(this.chunkCapData.x, this.chunkCapData.z))) {
            ChunkClientDataHelper.addCapData(this.chunkCapData);
            return;
        }
        LevelChunk chunk = world.m_6325_(this.chunkCapData.x, this.chunkCapData.z);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).orElseGet(null);
        if (cap != null && cap.getOwningColony() != this.chunkCapData.owningColony) {
            ChunkClientDataHelper.applyCap(this.chunkCapData, chunk);
        }
    }
}

