/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.util.FurnaceRecipes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateClientWithRecipesMessage
implements IMessage {
    private Map<ItemStorage, RecipeStorage> recipes;

    public UpdateClientWithRecipesMessage() {
    }

    public UpdateClientWithRecipesMessage(@NotNull Map<ItemStorage, RecipeStorage> recipes) {
        this.recipes = recipes;
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.recipes = new HashMap<ItemStorage, RecipeStorage>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ItemStack result = buf.m_130267_();
            RecipeStorage storage = (RecipeStorage)StandardFactoryController.getInstance().deserialize(buf.m_130260_());
            this.recipes.put(new ItemStorage(result), storage);
        }
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.recipes.size());
        for (Map.Entry<ItemStorage, RecipeStorage> entry : this.recipes.entrySet()) {
            buf.m_130055_(entry.getKey().getItemStack());
            buf.m_130079_(StandardFactoryController.getInstance().serialize(entry.getValue()));
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        FurnaceRecipes.getInstance().setMap(this.recipes);
    }
}

