/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.network.IMessage;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class VanillaParticleMessage
implements IMessage {
    private double x;
    private double y;
    private double z;
    private SimpleParticleType type;

    public VanillaParticleMessage() {
    }

    public VanillaParticleMessage(double x, double y, double z, SimpleParticleType type) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
    }

    @Override
    public void fromBytes(FriendlyByteBuf byteBuf) {
        this.x = byteBuf.readDouble();
        this.y = byteBuf.readDouble();
        this.z = byteBuf.readDouble();
        this.type = (SimpleParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(byteBuf.m_130281_());
    }

    @Override
    public void toBytes(FriendlyByteBuf byteBuf) {
        byteBuf.writeDouble(this.x);
        byteBuf.writeDouble(this.y);
        byteBuf.writeDouble(this.z);
        byteBuf.m_130085_(this.type.getRegistryName());
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        this.spawnParticles(this.type, (Level)world, this.x, this.y, this.z);
    }

    private void spawnParticles(SimpleParticleType particleType, Level world, double x, double y, double z) {
        Random rand = new Random();
        for (int i = 0; i < 5; ++i) {
            double d0 = rand.nextGaussian() * 0.02;
            double d1 = rand.nextGaussian() * 0.02;
            double d2 = rand.nextGaussian() * 0.02;
            world.m_7106_((ParticleOptions)particleType, x + (double)rand.nextFloat() * 0.6 * 2.0 - 0.6, y + 1.0 + (double)rand.nextFloat() * 1.8, z + (double)rand.nextFloat() * 0.6 * 2.0 - 0.6, d0, d1, d2);
        }
    }
}

