/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.blocks.BlockDecorationController;
import com.minecolonies.coremod.tileentities.TileEntityDecorationController;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecorationControllerUpdateMessage
implements IMessage {
    private BlockPos pos;
    private String name;
    private int level;

    public DecorationControllerUpdateMessage() {
    }

    public DecorationControllerUpdateMessage(@NotNull BlockPos pos, String name, int level) {
        this.pos = pos;
        this.name = name;
        this.level = level;
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.name = buf.m_130136_(Short.MAX_VALUE);
        this.pos = buf.m_130135_();
        this.level = buf.readInt();
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.m_130070_(this.name);
        buf.m_130064_(this.pos);
        buf.writeInt(this.level);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayer player = ctxIn.getSender();
        BlockEntity tileEntity = player.m_20193_().m_7702_(this.pos);
        if (tileEntity instanceof TileEntityDecorationController) {
            BlockState state = player.m_20193_().m_8055_(this.pos);
            Direction basicFacing = (Direction)state.m_61143_((Property)BlockDecorationController.f_54117_);
            ((TileEntityDecorationController)tileEntity).setSchematicPath(this.name + this.level);
            ((TileEntityDecorationController)tileEntity).setTier(this.level);
            ((TileEntityDecorationController)tileEntity).setBasicFacing(basicFacing);
        }
    }
}

