/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.inventory.container.ContainerCraftingFurnace;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class TransferRecipeCraftingTeachingMessage
implements IMessage {
    private boolean complete;
    private Map<Integer, ItemStack> itemStacks = new HashMap<Integer, ItemStack>();

    public TransferRecipeCraftingTeachingMessage() {
    }

    public TransferRecipeCraftingTeachingMessage(Map<Integer, ItemStack> itemStacks, boolean complete) {
        this.itemStacks = itemStacks;
        this.complete = complete;
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.itemStacks.clear();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            this.itemStacks.put(buf.readInt(), buf.m_130267_());
        }
        this.complete = buf.readBoolean();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.itemStacks.size());
        this.itemStacks.forEach((slot, stack) -> {
            buf.writeInt(slot.intValue());
            buf.m_130055_(stack);
        });
        buf.writeBoolean(this.complete);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayer player = ctxIn.getSender();
        if (player.f_36096_ instanceof ContainerCrafting) {
            ContainerCrafting container = (ContainerCrafting)player.f_36096_;
            if (this.complete) {
                container.handleSlotClick(container.m_38853_(1), this.itemStacks.getOrDefault(0, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.m_38853_(2), this.itemStacks.getOrDefault(1, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.m_38853_(3), this.itemStacks.getOrDefault(2, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.m_38853_(4), this.itemStacks.getOrDefault(3, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.m_38853_(5), this.itemStacks.getOrDefault(4, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.m_38853_(6), this.itemStacks.getOrDefault(5, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.m_38853_(7), this.itemStacks.getOrDefault(6, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.m_38853_(8), this.itemStacks.getOrDefault(7, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.m_38853_(9), this.itemStacks.getOrDefault(8, ItemStackUtils.EMPTY));
            } else {
                container.handleSlotClick(container.m_38853_(1), this.itemStacks.getOrDefault(0, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.m_38853_(2), this.itemStacks.getOrDefault(1, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.m_38853_(3), this.itemStacks.getOrDefault(3, ItemStackUtils.EMPTY));
                container.handleSlotClick(container.m_38853_(4), this.itemStacks.getOrDefault(4, ItemStackUtils.EMPTY));
            }
            container.m_38946_();
        } else if (player.f_36096_ instanceof ContainerCraftingFurnace) {
            ContainerCraftingFurnace container = (ContainerCraftingFurnace)player.f_36096_;
            container.setFurnaceInput(this.itemStacks.getOrDefault(0, ItemStack.f_41583_));
        }
    }
}

