/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.crusher;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCrusher;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class CrusherSetModeMessage
extends AbstractBuildingServerMessage<BuildingCrusher> {
    private int quantity;
    private ItemStack crusherMode;

    public CrusherSetModeMessage() {
    }

    public CrusherSetModeMessage(@NotNull BuildingCrusher.View building, ItemStorage crusherMode, int dailyQuantity) {
        super(building);
        this.quantity = dailyQuantity;
        this.crusherMode = crusherMode.getItemStack();
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.quantity = buf.readInt();
        this.crusherMode = buf.m_130267_();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.quantity);
        buf.m_130055_(this.crusherMode);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, BuildingCrusher building) {
        ServerPlayer player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        int qty = this.quantity;
        if (qty > building.getMaxDailyQuantity()) {
            qty = building.getMaxDailyQuantity();
            player.m_6352_((Component)new TranslatableComponent("com.minecolonies.coremod.crusher.toomuch", new Object[]{qty}), player.m_142081_());
        }
        building.setCrusherMode(new ItemStorage(this.crusherMode), qty);
    }
}

