/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchRequirements;
import com.minecolonies.api.research.registry.ResearchRequirementEntry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;

public class BuildingResearchRequirement
implements IResearchRequirement {
    private static final String TAG_BUILDING_NAME = "building-name";
    private static final String TAG_BUILDING_LVL = "building-lvl";
    private static final String TAG_BUILDING_SINGLE = "building-single";
    private final int buildingLevel;
    private final String building;
    private final boolean singleBuilding;

    public BuildingResearchRequirement(int buildingLevel, String building, boolean singleBuilding) {
        this.buildingLevel = buildingLevel;
        this.building = building;
        this.singleBuilding = singleBuilding;
    }

    public BuildingResearchRequirement(CompoundTag nbt) {
        this.buildingLevel = nbt.m_128451_(TAG_BUILDING_LVL);
        this.building = nbt.m_128461_(TAG_BUILDING_NAME);
        this.singleBuilding = nbt.m_128471_(TAG_BUILDING_SINGLE);
    }

    public String getBuilding() {
        return this.building;
    }

    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    @Override
    public boolean isFulfilled(IColony colony) {
        return colony.hasBuilding(this.building, this.buildingLevel, this.singleBuilding);
    }

    @Override
    public TranslatableComponent getDesc() {
        if (this.singleBuilding) {
            return new TranslatableComponent("com.minecolonies.coremod.research.requirement.building.mandatory.level", new Object[]{new TranslatableComponent("com.minecolonies.building." + this.building), this.buildingLevel});
        }
        return new TranslatableComponent("com.minecolonies.coremod.research.requirement.building.level", new Object[]{new TranslatableComponent("com.minecolonies.building." + this.building), this.buildingLevel});
    }

    @Override
    public ResearchRequirementEntry getRegistryEntry() {
        return ModResearchRequirements.buildingResearchRequirement;
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(TAG_BUILDING_NAME, this.building);
        nbt.m_128405_(TAG_BUILDING_LVL, this.buildingLevel);
        nbt.m_128379_(TAG_BUILDING_SINGLE, this.singleBuilding);
        return nbt;
    }
}

