/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IChunkmanagerCapability;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.ChunkLoadStorage;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.IColonyManagerCapability;
import com.minecolonies.coremod.network.messages.client.UpdateChunkCapabilityMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.NotNull;

public final class ChunkDataHelper {
    private ChunkDataHelper() {
    }

    public static void loadChunk(LevelChunk chunk, Level world) {
        IColony colony;
        int closeColony;
        int distanceToDelete = (Integer)MineColonies.getConfig().getServer().maxColonySize.get() * 16 * 2 * 5;
        IChunkmanagerCapability chunkManager = world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        if (!chunkManager.getAllChunkStorages().isEmpty()) {
            IColonyManagerCapability cap = world.getCapability(MineColonies.COLONY_MANAGER_CAP, null).resolve().orElse(null);
            if (cap == null) {
                return;
            }
            ChunkLoadStorage existingStorage = chunkManager.getChunkStorage(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
            if (existingStorage != null) {
                ChunkDataHelper.addStorageToChunk(chunk, existingStorage);
            }
        }
        if ((closeColony = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).map(IColonyTagCapability::getOwningColony).orElse(0).intValue()) != 0 && (colony = IColonyManager.getInstance().getColonyByDimension(closeColony, (ResourceKey<Level>)world.m_46472_())) != null) {
            colony.addLoadedChunk(ChunkPos.m_45589_((int)chunk.m_7697_().f_45578_, (int)chunk.m_7697_().f_45579_), chunk);
        }
    }

    public static void unloadChunk(LevelChunk chunk, Level world) {
        IColony colony;
        int closeColony = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).map(IColonyTagCapability::getOwningColony).orElse(0);
        if (closeColony != 0 && (colony = IColonyManager.getInstance().getColonyByDimension(closeColony, (ResourceKey<Level>)world.m_46472_())) != null) {
            colony.removeLoadedChunk(ChunkPos.m_45589_((int)chunk.m_7697_().f_45578_, (int)chunk.m_7697_().f_45579_));
        }
    }

    public static void addStorageToChunk(LevelChunk chunk, ChunkLoadStorage storage) {
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        storage.applyToCap(cap, chunk);
        if (cap != null) {
            Network.getNetwork().sendToEveryone(new UpdateChunkCapabilityMessage(cap, chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_));
        }
    }

    public static void claimColonyChunks(Level world, boolean add, int id, BlockPos center, ResourceKey<Level> dimension) {
        int range = (Integer)MineColonies.getConfig().getServer().initialColonySize.get();
        int buffer = (Integer)MineColonies.getConfig().getServer().minColonyDistance.get();
        ChunkDataHelper.claimChunksInRange(id, dimension, add, center, range, buffer, world);
    }

    public static void claimColonyChunks(IColony colony, boolean add, BlockPos center, int range) {
        ChunkDataHelper.claimChunksInRange(colony, add, range, center, false);
    }

    public static boolean canClaimChunksInRange(Level w, BlockPos pos, int range) {
        IChunkmanagerCapability worldCapability = w.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (worldCapability == null) {
            return true;
        }
        LevelChunk centralChunk = w.m_46745_(pos);
        int chunkX = centralChunk.m_7697_().f_45578_;
        int chunkZ = centralChunk.m_7697_().f_45579_;
        for (int i = chunkX - range; i <= chunkX + range; ++i) {
            for (int j = chunkZ - range; j <= chunkZ + range; ++j) {
                LevelChunk chunk = w.m_6325_(i, j);
                IColonyTagCapability colonyCap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
                if (colonyCap == null) {
                    return true;
                }
                ChunkLoadStorage storage = worldCapability.getChunkStorage(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
                if (storage != null) {
                    storage.applyToCap(colonyCap, chunk);
                }
                if (colonyCap.getOwningColony() == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static void claimChunksInRange(IColony colony, boolean add, int range, BlockPos center, boolean force) {
        Level world = colony.getWorld();
        int colonyId = colony.getID();
        ResourceKey<Level> dimension = colony.getDimension();
        boolean areAllChunksAdded = true;
        IChunkmanagerCapability chunkManager = world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        int chunkColonyCenterX = colony.getCenter().m_123341_() >> 4;
        int chunkColonyCenterZ = colony.getCenter().m_123343_() >> 4;
        BlockPos colonyCenterCompare = new BlockPos(colony.getCenter().m_123341_(), 0, colony.getCenter().m_123343_());
        int chunkX = center.m_123341_() >> 4;
        int chunkZ = center.m_123343_() >> 4;
        int initialColonySize = (Integer)MineColonies.getConfig().getServer().initialColonySize.get();
        int maxColonySize = (Integer)MineColonies.getConfig().getServer().maxColonySize.get();
        for (int i = chunkX - range; i <= chunkX + range; ++i) {
            for (int j = chunkZ - range; j <= chunkZ + range; ++j) {
                if (!force && !add && Math.abs(chunkColonyCenterX - i) <= initialColonySize + 1 && Math.abs(chunkColonyCenterZ - j) <= initialColonySize + 1) {
                    Log.getLogger().debug("Unclaim of initial chunk prevented");
                    continue;
                }
                BlockPos pos = new BlockPos(i * 16, 0, j * 16);
                if (!force && maxColonySize != 0 && pos.m_123331_((Vec3i)colonyCenterCompare) > Math.pow(maxColonySize * 16, 2.0)) {
                    Log.getLogger().debug("Tried to claim chunk at pos X:" + pos.m_123341_() + " Z:" + pos.m_123343_() + " too far away from the colony:" + colony.getID() + " center:" + colony.getCenter() + " max is config workingRangeTownHall ^2");
                    continue;
                }
                if (ChunkDataHelper.loadChunkAndAddData(world, pos, add, colonyId, center, chunkManager)) continue;
                areAllChunksAdded = false;
                @NotNull ChunkLoadStorage newStorage = new ChunkLoadStorage(colonyId, ChunkPos.m_45589_((int)i, (int)j), dimension.m_135782_(), center);
                chunkManager.addChunkStorage(i, j, newStorage);
            }
        }
        if (areAllChunksAdded && add && range > 0) {
            IBuilding building = colony.getBuildingManager().getBuilding(center);
            LanguageHandler.sendPlayersMessage(colony.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.colonysizechange", (Object[])new Object[]{range, building.getSchematicName()});
        }
    }

    public static void claimChunksInRange(int colonyId, ResourceKey<Level> dimension, boolean add, BlockPos center, int range, int buffer, Level world) {
        IChunkmanagerCapability chunkManager = world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        LevelChunk centralChunk = world.m_46745_(center);
        ChunkDataHelper.loadChunkAndAddData(world, center, add, colonyId, chunkManager);
        int chunkX = centralChunk.m_7697_().f_45578_;
        int chunkZ = centralChunk.m_7697_().f_45579_;
        int maxRange = range * 2 + buffer;
        for (int i = chunkX - maxRange; i <= chunkX + maxRange; ++i) {
            for (int j = chunkZ - maxRange; j <= chunkZ + maxRange; ++j) {
                if (i == chunkX && j == chunkZ || i >= chunkX - 5 && j >= chunkZ - 5 && i <= chunkX + 5 && j <= chunkZ + 5 && ChunkDataHelper.loadChunkAndAddData(world, new BlockPos(i * 16, 0, j * 16), add, colonyId, chunkManager)) continue;
                boolean owning = i >= chunkX - range && j >= chunkZ - range && i <= chunkX + range && j <= chunkZ + range;
                @NotNull ChunkLoadStorage newStorage = new ChunkLoadStorage(colonyId, ChunkPos.m_45589_((int)i, (int)j), add, dimension.m_135782_(), owning);
                chunkManager.addChunkStorage(i, j, newStorage);
            }
        }
    }

    public static void debugChunksInRange(int chunkX, int chunkZ, int range, int buffer, Level world) {
        IChunkmanagerCapability chunkManager = world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        int maxRange = range * 2 + buffer;
        for (int i = chunkX - maxRange; i <= chunkX + maxRange; ++i) {
            for (int j = chunkZ - maxRange; j <= chunkZ + maxRange; ++j) {
                BlockPos pos = new BlockPos(i * 16, 0, j * 16);
                LevelChunk chunk = world.m_46745_(pos);
                if (chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).map(IColonyTagCapability::getOwningColony).orElse(0) == 0) continue;
                Log.getLogger().warn("Has owner: " + pos.toString());
            }
        }
    }

    public static boolean loadChunkAndAddData(Level world, BlockPos pos, boolean add, int id, IChunkmanagerCapability chunkManager) {
        if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos)) {
            return false;
        }
        LevelChunk chunk = (LevelChunk)world.m_46865_(pos);
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        if (cap == null) {
            return false;
        }
        ChunkLoadStorage chunkLoadStorage = chunkManager.getChunkStorage(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
        if (chunkLoadStorage != null) {
            chunkLoadStorage.applyToCap(cap, chunk);
        }
        if (cap.getOwningColony() == id && add) {
            return true;
        }
        if (add) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(id, (ResourceKey<Level>)world.m_46472_());
            if (colony != null) {
                colony.addLoadedChunk(ChunkPos.m_45589_((int)chunk.m_7697_().f_45578_, (int)chunk.m_7697_().f_45579_), chunk);
            }
            cap.setOwningColony(id, chunk);
            cap.addColony(id, chunk);
        } else {
            cap.removeColony(id, chunk);
        }
        Network.getNetwork().sendToEveryone(new UpdateChunkCapabilityMessage(cap, chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_));
        return true;
    }

    public static boolean loadChunkAndAddData(Level world, BlockPos pos, boolean add, int id, BlockPos buildingPos, IChunkmanagerCapability chunkManager) {
        if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos)) {
            return false;
        }
        LevelChunk chunk = world.m_46745_(pos);
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        if (cap == null) {
            return false;
        }
        ChunkLoadStorage chunkLoadStorage = chunkManager.getChunkStorage(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
        if (chunkLoadStorage != null) {
            chunkLoadStorage.applyToCap(cap, chunk);
        }
        if (add) {
            cap.addBuildingClaim(id, buildingPos, chunk);
        } else {
            cap.removeBuildingClaim(id, buildingPos, chunk);
        }
        Network.getNetwork().sendToEveryone(new UpdateChunkCapabilityMessage(cap, chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_));
        return true;
    }
}

