/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block.vanilla;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.ldtteam.domumornamentum.block.AbstractBlockFenceGate;
import com.ldtteam.domumornamentum.block.ICachedItemGroupBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.components.SimpleRetexturableComponent;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.entity.block.MateriallyTexturedBlockEntity;
import com.ldtteam.domumornamentum.entity.block.ModBlockEntityTypes;
import com.ldtteam.domumornamentum.item.vanilla.FenceGateBlockItem;
import com.ldtteam.domumornamentum.tag.ModTags;
import com.ldtteam.domumornamentum.util.BlockUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FenceGateBlock
extends AbstractBlockFenceGate<FenceGateBlock>
implements IMateriallyTexturedBlock,
EntityBlock,
ICachedItemGroupBlock {
    public static final List<IMateriallyTexturedBlockComponent> COMPONENTS = ImmutableList.builder().add((Object)new SimpleRetexturableComponent(new ResourceLocation("minecraft:block/oak_planks"), (Tag<Block>)ModTags.FENCE_GATE_MATERIALS, Blocks.f_50705_)).build();
    private final List<ItemStack> fillItemGroupCache = Lists.newArrayList();

    public FenceGateBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)Blocks.f_50705_.m_60590_()).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_));
        this.setRegistryName("domum_ornamentum", "vanilla_fence_gate_compat");
    }

    @Override
    public void registerItemBlock(IForgeRegistry<Item> registry, Item.Properties properties) {
        registry.register((IForgeRegistryEntry)((Item)new FenceGateBlockItem(this, properties).setRegistryName(Objects.requireNonNull(this.getRegistryName()))));
    }

    @NotNull
    public List<IMateriallyTexturedBlockComponent> getComponents() {
        return COMPONENTS;
    }

    public void m_49811_(@NotNull CreativeModeTab group, @NotNull NonNullList<ItemStack> items) {
        if (!this.fillItemGroupCache.isEmpty()) {
            items.addAll(this.fillItemGroupCache);
            return;
        }
        try {
            ItemStack result = new ItemStack((ItemLike)this);
            this.fillItemGroupCache.add(result);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        items.addAll(this.fillItemGroupCache);
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        CompoundTag textureData = stack.m_41698_("textureData");
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof MateriallyTexturedBlockEntity) {
            ((MateriallyTexturedBlockEntity)tileEntity).updateTextureDataWith(MaterialTextureData.deserializeFromNBT(textureData));
        }
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new MateriallyTexturedBlockEntity(ModBlockEntityTypes.MATERIALLY_TEXTURED, blockPos, blockState);
    }

    @Override
    public void resetCache() {
        this.fillItemGroupCache.clear();
    }

    @NotNull
    public List<ItemStack> m_7381_(@NotNull BlockState state, @NotNull LootContext.Builder builder) {
        return BlockUtils.getMaterializedItemStack(builder);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return BlockUtils.getMaterializedItemStack((Entity)player, world, pos);
    }

    @Override
    @NotNull
    public Block getBlock() {
        return this;
    }
}

