/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.fence;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import com.ldtteam.datagenerators.blockstate.multipart.MultipartCaseJson;
import com.ldtteam.datagenerators.blockstate.multipart.MultipartWhenJson;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.vanilla.FenceBlock;
import com.ldtteam.domumornamentum.util.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import org.jetbrains.annotations.NotNull;

public class FenceBlockStateProvider
implements DataProvider {
    private final DataGenerator generator;

    public FenceBlockStateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(@NotNull HashCache cache) throws IOException {
        this.createBlockstateFile(cache, ModBlocks.getInstance().getFence());
    }

    private void createBlockstateFile(HashCache cache, FenceBlock fenceBlock) throws IOException {
        if (fenceBlock.getRegistryName() == null) {
            return;
        }
        ArrayList cases = Lists.newArrayList();
        cases.add(new MultipartCaseJson(new BlockstateVariantJson(new BlockstateModelJson("domum_ornamentum:block/fences/fence_post")), null));
        for (Direction possibleValue : HorizontalDirectionalBlock.f_54117_.m_6908_()) {
            cases.add(new MultipartCaseJson(new BlockstateVariantJson(new BlockstateModelJson("domum_ornamentum:block/fences/fence_side", 0, this.getYFromFacing(possibleValue))), new MultipartWhenJson(possibleValue.m_122433_().toLowerCase(Locale.ROOT), "true")));
        }
        BlockstateJson blockstate = new BlockstateJson((List)cases);
        Path blockstateFolder = this.generator.m_123916_().resolve("assets/domum_ornamentum/blockstates/");
        Path blockstatePath = blockstateFolder.resolve(fenceBlock.getRegistryName().m_135815_() + ".json");
        DataProvider.m_123920_((Gson)DataGeneratorConstants.GSON, (HashCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)blockstate), (Path)blockstatePath);
    }

    @NotNull
    public String m_6055_() {
        return "Fence BlockStates Provider";
    }

    private int getYFromFacing(Direction facing) {
        switch (facing) {
            default: {
                return 0;
            }
            case EAST: {
                return 90;
            }
            case SOUTH: {
                return 180;
            }
            case WEST: 
        }
        return 270;
    }
}

