/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.panel;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import com.ldtteam.domumornamentum.block.AbstractPanelBlockTrapdoor;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.PanelBlock;
import com.ldtteam.domumornamentum.block.types.TrapdoorType;
import com.ldtteam.domumornamentum.block.vanilla.TrapdoorBlock;
import com.ldtteam.domumornamentum.util.DataGeneratorConstants;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import org.jetbrains.annotations.NotNull;

public class PanelBlockStateProvider
implements DataProvider {
    private final DataGenerator generator;

    public PanelBlockStateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(@NotNull HashCache cache) throws IOException {
        this.createBlockstateFile(cache, ModBlocks.getInstance().getPanel());
    }

    private void createBlockstateFile(HashCache cache, PanelBlock shingle) throws IOException {
        if (shingle.getRegistryName() == null) {
            return;
        }
        HashMap<CallSite, BlockstateVariantJson> variants = new HashMap<CallSite, BlockstateVariantJson>();
        for (Direction facingValue : BlockStateProperties.f_61374_.m_6908_()) {
            for (TrapdoorType typeValue : TrapdoorBlock.TYPE.m_6908_()) {
                for (Half halfValue : AbstractPanelBlockTrapdoor.HALF.m_6908_()) {
                    Iterator iterator = AbstractPanelBlockTrapdoor.OPEN.m_6908_().iterator();
                    while (iterator.hasNext()) {
                        boolean openValue = (Boolean)iterator.next();
                        String variantKey = "facing=" + facingValue + ",type=" + typeValue.m_7912_() + ",half=" + halfValue + ",open=" + openValue;
                        int y = this.getYFromFacing(facingValue);
                        int x = this.getXFromOpenAndHalf(openValue, halfValue);
                        String modelLocation = "domum_ornamentum:block/panels/panel_" + typeValue.m_7912_();
                        BlockstateModelJson model = new BlockstateModelJson(modelLocation, x, y += this.getYFromOpenAndHalf(openValue, halfValue));
                        BlockstateVariantJson variant = new BlockstateVariantJson(model);
                        variants.put((CallSite)((Object)variantKey), variant);
                    }
                }
            }
        }
        BlockstateJson blockstate = new BlockstateJson(variants);
        Path blockstateFolder = this.generator.m_123916_().resolve("assets/domum_ornamentum/blockstates/");
        Path blockstatePath = blockstateFolder.resolve(shingle.getRegistryName().m_135815_() + ".json");
        DataProvider.m_123920_((Gson)DataGeneratorConstants.GSON, (HashCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)blockstate), (Path)blockstatePath);
    }

    private int getYFromFacing(Direction facing) {
        return switch (facing) {
            default -> 0;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            case Direction.EAST -> 90;
        };
    }

    private int getYFromOpenAndHalf(boolean open, Half half) {
        return half == Half.TOP && open ? 180 : 0;
    }

    private int getXFromOpenAndHalf(boolean open, Half half) {
        if (!open) {
            return half == Half.TOP ? 180 : 0;
        }
        return half == Half.TOP ? -90 : 90;
    }

    @NotNull
    public String m_6055_() {
        return "Panel BlockStates Provider";
    }
}

