/*
 * Decompiled with CFR 0.152.
 */
package com.github.justin.humancompanions.entity;

import com.github.justin.humancompanions.core.EntityInit;
import com.github.justin.humancompanions.entity.AvoidCreeperGoal;
import com.github.justin.humancompanions.entity.CompanionData;
import com.github.justin.humancompanions.entity.CustomOwnerHurtByTargetGoal;
import com.github.justin.humancompanions.entity.CustomOwnerHurtTargetGoal;
import com.github.justin.humancompanions.entity.LowHealthGoal;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class AbstractHumanCompanionEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public SimpleContainer inventory = new SimpleContainer(27);
    public EquipmentSlot[] armorTypes = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD};

    public AbstractHumanCompanionEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.m_7105_(false);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_21573_().m_7008_(true);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, new AvoidCreeperGoal<Creeper>(this, Creeper.class, 10.0f, 1.5, 1.5));
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.3, 8.0f, 2.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(9, (Goal)new LowHealthGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new CustomOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new CustomOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.32);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setCompanionSkin(this.f_19796_.nextInt(CompanionData.maleSkins.length));
        this.m_6593_((Component)new TextComponent(CompanionData.getRandomName()));
        for (int i = 0; i < 4; ++i) {
            EquipmentSlot armorType = this.armorTypes[i];
            ItemStack itemstack = this.getSpawnArmor(armorType);
            if (itemstack.m_41619_()) continue;
            this.inventory.m_6836_(i, itemstack);
            this.checkArmor();
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)1);
    }

    public ResourceLocation getResourceLocation() {
        return CompanionData.maleSkins[this.getCompanionSkin()];
    }

    public int getCompanionSkin() {
        return (Integer)this.f_19804_.m_135370_(DATA_TYPE_ID);
    }

    public void setCompanionSkin(int skinIndex) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)skinIndex);
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob parent) {
        return (AgeableMob)((EntityType)EntityInit.KnightEntity.get()).m_20615_((Level)level);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (!this.f_19853_.f_46443_ && hand == InteractionHand.MAIN_HAND) {
            if (!this.m_21824_()) {
                if (itemstack.m_41614_()) {
                    itemstack.m_41774_(1);
                    if (this.f_19796_.nextInt(4) == 0) {
                        this.m_21828_(player);
                        player.m_6352_((Component)new TextComponent("Companion added"), this.m_142081_());
                    } else {
                        player.m_6352_((Component)new TranslatableComponent("chat.type.text", new Object[]{this.m_5446_(), CompanionData.tameFail[this.f_19796_.nextInt(CompanionData.tameFail.length)]}), this.m_142081_());
                    }
                } else {
                    player.m_6352_((Component)new TranslatableComponent("chat.type.text", new Object[]{this.m_5446_(), CompanionData.notTamed[this.f_19796_.nextInt(CompanionData.notTamed.length)]}), this.m_142081_());
                }
            } else {
                if (player.m_6144_()) {
                    if (!this.m_21827_()) {
                        this.m_21839_(true);
                        TextComponent text = new TextComponent("I'll stay here.");
                        player.m_6352_((Component)new TranslatableComponent("chat.type.text", new Object[]{this.m_5446_(), text}), this.m_142081_());
                    } else {
                        this.m_21839_(false);
                        TextComponent text = new TextComponent("I'll follow you.");
                        player.m_6352_((Component)new TranslatableComponent("chat.type.text", new Object[]{this.m_5446_(), text}), this.m_142081_());
                    }
                } else if (itemstack.m_41614_()) {
                    if (this.m_21223_() < this.m_21233_()) {
                        if (!player.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        this.m_5634_(item.m_41473_().m_38744_());
                        TextComponent text = new TextComponent(this.m_7755_().getString() + "'s health: " + this.m_21223_() + "/" + this.m_21233_());
                        player.m_6352_((Component)text, this.m_142081_());
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    this.openGui((ServerPlayer)player);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void openGui(ServerPlayer player) {
        player.m_5893_((MenuProvider)new SimpleMenuProvider((p_53124_, p_53125_, p_53126_) -> ChestMenu.m_39237_((int)p_53124_, (Inventory)p_53125_, (Container)this.inventory), this.m_5446_()));
    }

    public void checkArmor() {
        ItemStack head = this.m_6844_(EquipmentSlot.HEAD);
        ItemStack chest = this.m_6844_(EquipmentSlot.CHEST);
        ItemStack legs = this.m_6844_(EquipmentSlot.LEGS);
        ItemStack feet = this.m_6844_(EquipmentSlot.FEET);
        block6: for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (!(itemstack.m_41720_() instanceof ArmorItem)) continue;
            switch (((ArmorItem)itemstack.m_41720_()).m_40402_()) {
                case HEAD: {
                    if (head.m_41619_()) {
                        this.m_8061_(EquipmentSlot.HEAD, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.m_41720_()).m_40404_() > ((ArmorItem)head.m_41720_()).m_40404_()) {
                        this.m_8061_(EquipmentSlot.HEAD, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.m_41720_()).m_40401_() != ArmorMaterials.NETHERITE || ((ArmorItem)head.m_41720_()).m_40401_() == ArmorMaterials.NETHERITE) continue block6;
                    this.m_8061_(EquipmentSlot.HEAD, itemstack);
                    continue block6;
                }
                case CHEST: {
                    if (chest.m_41619_()) {
                        this.m_8061_(EquipmentSlot.CHEST, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.m_41720_()).m_40404_() > ((ArmorItem)chest.m_41720_()).m_40404_()) {
                        this.m_8061_(EquipmentSlot.CHEST, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.m_41720_()).m_40401_() != ArmorMaterials.NETHERITE || ((ArmorItem)chest.m_41720_()).m_40401_() == ArmorMaterials.NETHERITE) continue block6;
                    this.m_8061_(EquipmentSlot.CHEST, itemstack);
                    continue block6;
                }
                case LEGS: {
                    if (legs.m_41619_()) {
                        this.m_8061_(EquipmentSlot.LEGS, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.m_41720_()).m_40404_() > ((ArmorItem)legs.m_41720_()).m_40404_()) {
                        this.m_8061_(EquipmentSlot.LEGS, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.m_41720_()).m_40401_() != ArmorMaterials.NETHERITE || ((ArmorItem)legs.m_41720_()).m_40401_() == ArmorMaterials.NETHERITE) continue block6;
                    this.m_8061_(EquipmentSlot.LEGS, itemstack);
                    continue block6;
                }
                case FEET: {
                    if (feet.m_41619_()) {
                        this.m_8061_(EquipmentSlot.FEET, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.m_41720_()).m_40404_() > ((ArmorItem)feet.m_41720_()).m_40404_()) {
                        this.m_8061_(EquipmentSlot.FEET, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.m_41720_()).m_40401_() != ArmorMaterials.NETHERITE || ((ArmorItem)feet.m_41720_()).m_40401_() == ArmorMaterials.NETHERITE) continue block6;
                    this.m_8061_(EquipmentSlot.FEET, itemstack);
                }
            }
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("inventory", (Tag)this.inventory.m_7927_());
        tag.m_128405_("skin", this.getCompanionSkin());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setCompanionSkin(tag.m_128451_("skin"));
        if (tag.m_128425_("inventory", 9)) {
            this.inventory.m_7797_(tag.m_128437_("inventory", 10));
        }
        this.m_8061_(EquipmentSlot.FEET, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.LEGS, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
        this.checkArmor();
    }

    public boolean m_6469_(DamageSource p_34288_, float p_34289_) {
        if (p_34288_.m_7639_() instanceof TamableAnimal && this.m_21824_() && ((TamableAnimal)p_34288_.m_7639_()).m_21824_() && this.m_142480_().m_7306_((Entity)((TamableAnimal)p_34288_.m_7639_()).m_142480_())) {
            return false;
        }
        this.m_6472_(p_34288_, p_34289_);
        return super.m_6469_(p_34288_, p_34289_);
    }

    public void m_6472_(DamageSource p_150073_, float p_150074_) {
        if (!(p_150074_ <= 0.0f)) {
            if ((p_150074_ /= 4.0f) < 1.0f) {
                p_150074_ = 1.0f;
            }
            for (ItemStack itemstack : this.m_6168_()) {
                if (p_150073_.m_19384_() && itemstack.m_41720_().m_41475_() || !(itemstack.m_41720_() instanceof ArmorItem)) continue;
                itemstack.m_41622_((int)p_150074_, (LivingEntity)this, p_35997_ -> p_35997_.m_21166_(((ArmorItem)itemstack.m_41720_()).m_40402_()));
            }
        }
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
    }

    protected void m_5907_() {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
            this.m_19983_(itemstack);
        }
    }

    public boolean m_7327_(Entity entity) {
        ItemStack itemstack = this.m_21205_();
        if (!this.f_19853_.f_46443_ && !itemstack.m_41619_() && entity instanceof LivingEntity) {
            itemstack.m_41622_(1, (LivingEntity)this, p_43296_ -> p_43296_.m_21166_(EquipmentSlot.MAINHAND));
            if (this.m_21205_().m_41619_()) {
                TextComponent broken = new TextComponent("My sword broke!");
                if (this.m_21824_()) {
                    this.m_142480_().m_6352_((Component)new TranslatableComponent("chat.type.text", new Object[]{this.m_5446_(), broken}), this.m_142081_());
                }
            }
        }
        return super.m_7327_(entity);
    }

    public ItemStack getSpawnArmor(EquipmentSlot armorType) {
        float materialFloat = this.f_19796_.nextFloat();
        if (materialFloat <= 0.4f) {
            return ItemStack.f_41583_;
        }
        if (materialFloat < 0.7f) {
            switch (armorType) {
                case HEAD: {
                    return Items.f_42407_.m_7968_();
                }
                case CHEST: {
                    return Items.f_42408_.m_7968_();
                }
                case LEGS: {
                    return Items.f_42462_.m_7968_();
                }
                case FEET: {
                    return Items.f_42463_.m_7968_();
                }
            }
        } else if (materialFloat < 0.9f) {
            switch (armorType) {
                case HEAD: {
                    return Items.f_42464_.m_7968_();
                }
                case CHEST: {
                    return Items.f_42465_.m_7968_();
                }
                case LEGS: {
                    return Items.f_42466_.m_7968_();
                }
                case FEET: {
                    return Items.f_42467_.m_7968_();
                }
            }
        } else {
            switch (armorType) {
                case HEAD: {
                    return Items.f_42468_.m_7968_();
                }
                case CHEST: {
                    return Items.f_42469_.m_7968_();
                }
                case LEGS: {
                    return Items.f_42470_.m_7968_();
                }
                case FEET: {
                    return Items.f_42471_.m_7968_();
                }
            }
        }
        return ItemStack.f_41583_;
    }
}

