/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.init;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.FertilityConfig;
import sereneseasons.config.ServerConfig;
import sereneseasons.init.ModTags;

public class ModFertility {
    private static HashSet<String> springPlants = new HashSet();
    private static HashSet<String> summerPlants = new HashSet();
    private static HashSet<String> autumnPlants = new HashSet();
    private static HashSet<String> winterPlants = new HashSet();
    private static HashSet<String> allListedPlants = new HashSet();
    private static HashMap<String, Integer> seedSeasons = new HashMap();

    public static void populate() {
        springPlants.clear();
        summerPlants.clear();
        autumnPlants.clear();
        winterPlants.clear();
        allListedPlants.clear();
        seedSeasons.clear();
        ModFertility.populateSeasonCrops(ModTags.Blocks.spring_crops.m_6497_(), springPlants, 1);
        ModFertility.populateSeasonCrops(ModTags.Blocks.summer_crops.m_6497_(), summerPlants, 2);
        ModFertility.populateSeasonCrops(ModTags.Blocks.autumn_crops.m_6497_(), autumnPlants, 4);
        ModFertility.populateSeasonCrops(ModTags.Blocks.winter_crops.m_6497_(), winterPlants, 8);
        ModFertility.populateSeasonSeeds(ModTags.Items.spring_crops.m_6497_(), springPlants, 1);
        ModFertility.populateSeasonSeeds(ModTags.Items.summer_crops.m_6497_(), summerPlants, 2);
        ModFertility.populateSeasonSeeds(ModTags.Items.autumn_crops.m_6497_(), autumnPlants, 4);
        ModFertility.populateSeasonSeeds(ModTags.Items.winter_crops.m_6497_(), winterPlants, 8);
    }

    public static boolean isCropFertile(String cropName, Level world, BlockPos pos) {
        Season season = SeasonHelper.getSeasonState(world).getSeason();
        Biome biome = world.m_46857_(pos);
        ResourceKey biomeKey = world.m_45837_(pos).orElse(null);
        if ((Integer)FertilityConfig.undergroundFertilityLevel.get() > -1 && pos.m_123342_() < (Integer)FertilityConfig.undergroundFertilityLevel.get() && !world.m_45527_(pos)) {
            return true;
        }
        if (BiomeConfig.infertileBiome((ResourceKey<Biome>)biomeKey)) {
            return false;
        }
        if (!(((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() && BiomeConfig.enablesSeasonalEffects((ResourceKey<Biome>)biomeKey) && ServerConfig.isDimensionWhitelisted((ResourceKey<Level>)world.m_46472_()))) {
            return true;
        }
        if (BiomeConfig.usesTropicalSeasons((ResourceKey<Biome>)biomeKey)) {
            return summerPlants.contains(cropName) || !allListedPlants.contains(cropName);
        }
        if (!biome.m_198906_(pos)) {
            return winterPlants.contains(cropName);
        }
        if (season == Season.SPRING && springPlants.contains(cropName)) {
            return true;
        }
        if (season == Season.SUMMER && summerPlants.contains(cropName)) {
            return true;
        }
        if (season == Season.AUTUMN && autumnPlants.contains(cropName)) {
            return true;
        }
        if (season == Season.WINTER && winterPlants.contains(cropName)) {
            return true;
        }
        return !allListedPlants.contains(cropName);
    }

    private static void populateSeasonCrops(List<Block> crops, HashSet<String> cropSet, int bitmask) {
        for (Block crop : crops) {
            if (crop == null || crop == Blocks.f_50016_) continue;
            String plantName = crop.getRegistryName().toString();
            cropSet.add(plantName);
            if (bitmask == 0) continue;
            allListedPlants.add(plantName);
            if (seedSeasons.containsKey(plantName)) {
                int seasons = seedSeasons.get(plantName);
                seedSeasons.put(plantName, seasons | bitmask);
                continue;
            }
            seedSeasons.put(plantName, bitmask);
        }
    }

    private static void populateSeasonSeeds(List<Item> seeds, HashSet<String> cropSet, int bitmask) {
        for (Item seed : seeds) {
            if (seed == null) continue;
            String plantName = seed.getRegistryName().toString();
            cropSet.add(plantName);
            if (bitmask == 0) continue;
            allListedPlants.add(plantName);
            if (seedSeasons.containsKey(plantName)) {
                int seasons = seedSeasons.get(plantName);
                seedSeasons.put(plantName, seasons | bitmask);
                continue;
            }
            seedSeasons.put(plantName, bitmask);
        }
    }

    public static void setupTooltips(ItemTooltipEvent event) {
        String name;
        if (((Boolean)FertilityConfig.cropTooltips.get()).booleanValue() && ((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() && seedSeasons.containsKey(name = event.getItemStack().m_41720_().getRegistryName().toString())) {
            int mask = seedSeasons.get(name);
            event.getToolTip().add(new TranslatableComponent("desc.sereneseasons.fertile_seasons").m_130946_(":"));
            if ((mask & 1) != 0 && (mask & 2) != 0 && (mask & 4) != 0 && (mask & 8) != 0) {
                event.getToolTip().add(new TextComponent(" ").m_7220_((Component)new TranslatableComponent("desc.sereneseasons.year_round").m_130940_(ChatFormatting.LIGHT_PURPLE)));
            } else {
                if ((mask & 1) != 0) {
                    event.getToolTip().add(new TextComponent(" ").m_7220_((Component)new TranslatableComponent("desc.sereneseasons.spring").m_130940_(ChatFormatting.GREEN)));
                }
                if ((mask & 2) != 0) {
                    event.getToolTip().add(new TextComponent(" ").m_7220_((Component)new TranslatableComponent("desc.sereneseasons.summer").m_130940_(ChatFormatting.YELLOW)));
                }
                if ((mask & 4) != 0) {
                    event.getToolTip().add(new TextComponent(" ").m_7220_((Component)new TranslatableComponent("desc.sereneseasons.autumn").m_130940_(ChatFormatting.GOLD)));
                }
                if ((mask & 8) != 0) {
                    event.getToolTip().add(new TextComponent(" ").m_7220_((Component)new TranslatableComponent("desc.sereneseasons.winter").m_130940_(ChatFormatting.AQUA)));
                }
            }
        }
    }
}

