/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.util.biome;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sereneseasons.core.SereneSeasons;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BiomeUtil {
    private static List<Level> worldList = Lists.newArrayList();

    public static ResourceKey<Biome> getBiomeKey(Biome biome) {
        if (biome == null) {
            throw new RuntimeException("Cannot get registry key for null biome");
        }
        if (biome.delegate.name() == null) {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                return BiomeUtil.getClientKey(biome);
            }
            throw new RuntimeException("Failed to get registry key for biome!");
        }
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)biome.delegate.name());
    }

    public static Biome getBiome(ResourceKey<Biome> key) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(key.m_135782_());
        if (biome == null) {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                try {
                    biome = BiomeUtil.getClientBiome(key);
                }
                catch (Exception e) {
                    SereneSeasons.logger.error(e.getMessage());
                }
                if (biome == null) {
                    biome = BiomeUtil.getBiomeFromWorlds(key);
                }
                return biome;
            }
            if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
                return BiomeUtil.getBiomeFromWorlds(key);
            }
        }
        return biome;
    }

    public static Biome getBiome(int id) {
        if (id == -1) {
            throw new RuntimeException("Attempted to get biome with id -1");
        }
        return BiomeUtil.getBiome((ResourceKey<Biome>)((ForgeRegistry)ForgeRegistries.BIOMES).getKey(id));
    }

    public static int getBiomeId(Biome biome) {
        if (biome == null) {
            throw new RuntimeException("Attempted to get id of null biome");
        }
        int id = ((ForgeRegistry)ForgeRegistries.BIOMES).getID((IForgeRegistryEntry)biome);
        if (id == -1) {
            throw new RuntimeException("Biome id is -1 for biome " + biome.delegate.name());
        }
        return id;
    }

    public static int getBiomeId(ResourceKey<Biome> key) {
        return BiomeUtil.getBiomeId(BiomeUtil.getBiome(key));
    }

    public static boolean exists(ResourceKey<Biome> key) {
        return ForgeRegistries.BIOMES.containsKey(key.m_135782_());
    }

    public static boolean exists(int id) {
        return BiomeUtil.getBiome(id) != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Registry<Biome> getClientBiomeRegistry() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel world = minecraft.f_91073_;
        if (world == null) {
            throw new RuntimeException("Cannot acquire biome registry when the world is null.");
        }
        return world.m_5962_().m_175515_(Registry.f_122885_);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static ResourceKey<Biome> getClientKey(Biome biome) {
        return (ResourceKey)BiomeUtil.getClientBiomeRegistry().m_7854_((Object)biome).orElseThrow(() -> new RuntimeException("Failed to get client registry key for biome!"));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Biome getClientBiome(ResourceKey<Biome> key) {
        Biome biome = (Biome)BiomeUtil.getClientBiomeRegistry().m_6246_(key);
        if (biome == null) {
            new RuntimeException("Failed to get client biome for registry key " + key.m_135782_().toString() + "!");
        }
        return biome;
    }

    private static Biome getBiomeFromWorlds(ResourceKey<Biome> key) {
        for (Level world : worldList) {
            Biome biome = (Biome)world.m_5962_().m_175515_(Registry.f_122885_).m_6246_(key);
            if (biome == null) continue;
            return biome;
        }
        throw new RuntimeException("Failed to get biome for registry key " + key.m_135782_().toString() + " !");
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        worldList.add((Level)event.getWorld());
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        worldList.remove((Level)event.getWorld());
    }
}

