/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityElephant;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.Random;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class ElephantAIForageLeaves
extends MoveToBlockGoal {
    private EntityElephant elephant;
    private int idleAtLeavesTime = 0;
    private boolean isAboveDestinationBear;

    public ElephantAIForageLeaves(EntityElephant elephant) {
        super((PathfinderMob)elephant, 0.7, 32, 5);
        this.elephant = elephant;
    }

    public boolean m_8036_() {
        return !this.elephant.m_6162_() && this.elephant.m_6688_() == null && this.elephant.getControllingVillager() == null && this.elephant.m_21205_().m_41619_() && !this.elephant.aiItemFlag && super.m_8036_();
    }

    public void m_8041_() {
        this.idleAtLeavesTime = 0;
    }

    public double m_8052_() {
        return 4.0;
    }

    public void m_8037_() {
        super.m_8037_();
        BlockPos blockpos = this.m_6669_();
        if (!this.isWithinXZDist(blockpos, this.f_25598_.m_20182_(), this.m_8052_())) {
            this.isAboveDestinationBear = false;
            ++this.f_25601_;
            if (this.m_8064_()) {
                this.f_25598_.m_21573_().m_26519_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, this.f_25599_);
            }
        } else {
            this.isAboveDestinationBear = true;
            --this.f_25601_;
        }
        if (this.m_25625_() && Math.abs(this.elephant.m_20186_() - (double)this.f_25602_.m_123342_()) <= 3.0) {
            this.elephant.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3((double)this.f_25602_.m_123341_() + 0.5, (double)this.f_25602_.m_123342_(), (double)this.f_25602_.m_123343_() + 0.5));
            if (this.elephant.m_20186_() + 2.0 < (double)this.f_25602_.m_123342_()) {
                if (this.elephant.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                    this.elephant.setAnimation(EntityElephant.ANIMATION_BREAKLEAVES);
                }
                this.elephant.setStanding(true);
                this.elephant.maxStandTime = 15;
            } else {
                this.elephant.setAnimation(EntityElephant.ANIMATION_BREAKLEAVES);
                this.elephant.setStanding(false);
            }
            if (this.idleAtLeavesTime >= 10) {
                this.breakLeaves();
            } else {
                ++this.idleAtLeavesTime;
            }
        }
    }

    protected int m_6099_(PathfinderMob p_203109_1_) {
        return 100 + p_203109_1_.m_21187_().nextInt(200);
    }

    private boolean isWithinXZDist(BlockPos blockpos, Vec3 positionVec, double distance) {
        return blockpos.m_123299_(positionVec.m_7096_(), (double)blockpos.m_123342_(), positionVec.m_7094_(), true) < distance * distance;
    }

    protected boolean m_25625_() {
        return this.isAboveDestinationBear;
    }

    private void breakLeaves() {
        if (ForgeEventFactory.getMobGriefingEvent((Level)this.elephant.f_19853_, (Entity)this.elephant)) {
            BlockState blockstate = this.elephant.f_19853_.m_8055_(this.f_25602_);
            if (BlockTags.m_13115_().m_13404_(AMTagRegistry.ELEPHANT_FOODBLOCKS).m_8110_((Object)blockstate.m_60734_())) {
                this.elephant.f_19853_.m_46961_(this.f_25602_, false);
                Random rand = new Random();
                ItemStack stack = new ItemStack((ItemLike)blockstate.m_60734_().m_5456_());
                ItemEntity itementity = new ItemEntity(this.elephant.f_19853_, (double)((float)this.f_25602_.m_123341_() + rand.nextFloat()), (double)((float)this.f_25602_.m_123342_() + rand.nextFloat()), (double)((float)this.f_25602_.m_123343_() + rand.nextFloat()), stack);
                itementity.m_32060_();
                this.elephant.f_19853_.m_7967_((Entity)itementity);
                if (BlockTags.m_13115_().m_13404_(AMTagRegistry.DROPS_ACACIA_BLOSSOMS).m_8110_((Object)blockstate.m_60734_()) && rand.nextInt(30) == 0) {
                    ItemStack banana = new ItemStack((ItemLike)AMItemRegistry.ACACIA_BLOSSOM);
                    ItemEntity itementity2 = new ItemEntity(this.elephant.f_19853_, (double)((float)this.f_25602_.m_123341_() + rand.nextFloat()), (double)((float)this.f_25602_.m_123342_() + rand.nextFloat()), (double)((float)this.f_25602_.m_123343_() + rand.nextFloat()), banana);
                    itementity2.m_32060_();
                    this.elephant.f_19853_.m_7967_((Entity)itementity2);
                }
                this.m_8041_();
            }
        }
    }

    protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
        return !this.elephant.aiItemFlag && BlockTags.m_13115_().m_13404_(AMTagRegistry.ELEPHANT_FOODBLOCKS).m_8110_((Object)worldIn.m_8055_(pos).m_60734_());
    }
}

