/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.world;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.config.BiomeConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCachalotWhale;
import com.github.alexthe666.alexsmobs.world.AMWorldData;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;

public class BeachedCachalotWhaleSpawner {
    private final Random random = new Random();
    private final ServerLevel world;
    private int timer;
    private int delay;
    private int chance;

    public BeachedCachalotWhaleSpawner(ServerLevel p_i50177_1_) {
        this.world = p_i50177_1_;
        this.timer = 1200;
        AMWorldData worldinfo = AMWorldData.get((Level)p_i50177_1_);
        this.delay = worldinfo.getBeachedCachalotSpawnDelay();
        this.chance = worldinfo.getBeachedCachalotSpawnChance();
        if (this.delay == 0 && this.chance == 0) {
            this.delay = AMConfig.beachedCachalotWhaleSpawnDelay;
            worldinfo.setBeachedCachalotSpawnDelay(this.delay);
            this.chance = 25;
            worldinfo.setBeachedCachalotSpawnChance(this.chance);
        }
    }

    public void tick() {
        if (AMConfig.beachedCachalotWhales && --this.timer <= 0 && this.world.m_46470_()) {
            this.timer = 1200;
            AMWorldData worldinfo = AMWorldData.get((Level)this.world);
            this.delay -= 1200;
            if (this.delay < 0) {
                this.delay = 0;
            }
            worldinfo.setBeachedCachalotSpawnDelay(this.delay);
            if (this.delay <= 0) {
                this.delay = AMConfig.beachedCachalotWhaleSpawnDelay;
                if (this.world.m_46469_().m_46207_(GameRules.f_46134_)) {
                    int i = this.chance;
                    this.chance = Mth.m_14045_((int)(this.chance + AMConfig.beachedCachalotWhaleSpawnChance), (int)5, (int)100);
                    worldinfo.setBeachedCachalotSpawnChance(this.chance);
                    if (this.random.nextInt(100) <= i && this.attemptSpawnWhale()) {
                        this.chance = AMConfig.beachedCachalotWhaleSpawnChance;
                    }
                }
            }
        }
    }

    private boolean attemptSpawnWhale() {
        ServerPlayer playerentity = this.world.m_8890_();
        if (playerentity == null) {
            return true;
        }
        if (this.random.nextInt(5) != 0) {
            return false;
        }
        BlockPos blockpos = new BlockPos(playerentity.m_20182_());
        BlockPos blockpos2 = this.func_221244_a(blockpos, 84);
        if (blockpos2 != null && this.func_226559_a_(blockpos2) && blockpos2.m_123331_((Vec3i)blockpos) > 225.0) {
            BlockPos upPos = new BlockPos(blockpos2.m_123341_(), blockpos2.m_123342_() + 2, blockpos2.m_123343_());
            EntityCachalotWhale whale = (EntityCachalotWhale)AMEntityRegistry.CACHALOT_WHALE.m_20615_((Level)this.world);
            whale.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, this.random.nextFloat() * 360.0f - 180.0f, 0.0f);
            whale.m_6518_((ServerLevelAccessor)this.world, this.world.m_6436_(upPos), MobSpawnType.SPAWNER, null, null);
            whale.setBeached(true);
            AMWorldData worldinfo = AMWorldData.get((Level)this.world);
            worldinfo.setBeachedCachalotID(whale.m_142081_());
            whale.m_21446_(upPos, 16);
            whale.setDespawnBeach(true);
            this.world.m_7967_((Entity)whale);
            return true;
        }
        return false;
    }

    @Nullable
    private BlockPos func_221244_a(BlockPos p_221244_1_, int p_221244_2_) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = p_221244_1_.m_123341_() + this.random.nextInt(p_221244_2_ * 2) - p_221244_2_;
            BlockPos blockpos1 = new BlockPos(j, l = this.world.m_6924_(Heightmap.Types.WORLD_SURFACE, j, k = p_221244_1_.m_123343_() + this.random.nextInt(p_221244_2_ * 2) - p_221244_2_), k);
            Biome biome = this.world.m_46857_(blockpos1);
            if (!BiomeConfig.test(BiomeConfig.cachalot_whale_beached_spawns, biome) || !NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)this.world, (BlockPos)blockpos1, (EntityType)EntityType.f_20494_)) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    private boolean func_226559_a_(BlockPos p_226559_1_) {
        BlockPos blockpos;
        Iterator var2 = BlockPos.m_121940_((BlockPos)p_226559_1_, (BlockPos)p_226559_1_.m_142082_(1, 2, 1)).iterator();
        do {
            if (var2.hasNext()) continue;
            return true;
        } while (this.world.m_8055_(blockpos = (BlockPos)var2.next()).m_60816_((BlockGetter)this.world, blockpos).m_83281_() && this.world.m_6425_(blockpos).m_76178_());
        return false;
    }
}

