/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.env.feature;

import com.google.gson.annotations.SerializedName;
import java.util.Map;
import net.minecraft.world.level.block.state.BlockState;
import team.creative.ambientsounds.env.feature.AmbientBlockGroup;
import team.creative.creativecore.common.util.type.map.HashMapDouble;

public class AmbientFeature {
    public String name;
    public transient AmbientBlockGroup blocks = new AmbientBlockGroup();
    public transient AmbientBlockGroup badBlocks = new AmbientBlockGroup();
    @SerializedName(value="low-weight")
    public Double lowWeight;
    @SerializedName(value="high-weight")
    public Double highWeight;
    @SerializedName(value="low-count")
    public Double lowCount;
    @SerializedName(value="high-count")
    public Double highCount;

    public double volume(HashMapDouble<BlockState> foundPercentage, HashMapDouble<BlockState> foundCount) {
        double volume = 1.0;
        if (this.lowWeight != null || this.highWeight != null) {
            double percentage = 0.0;
            for (Map.Entry entry : foundPercentage.entrySet()) {
                if (!this.blocks.is((BlockState)entry.getKey())) continue;
                percentage += ((Double)entry.getValue()).doubleValue();
            }
            if (this.lowWeight != null && this.lowWeight > percentage) {
                return 0.0;
            }
            if (this.highWeight == null || this.highWeight < percentage) {
                volume *= 1.0;
            } else {
                double low = this.lowWeight == null ? 0.0 : this.lowWeight;
                volume *= (percentage - low) / (this.highWeight - low);
            }
        }
        if (this.lowCount != null || this.highCount != null) {
            double count = 0.0;
            for (Map.Entry entry : foundCount.entrySet()) {
                if (!this.blocks.is((BlockState)entry.getKey())) continue;
                count += ((Double)entry.getValue()).doubleValue();
            }
            if (this.lowCount != null && this.lowCount > count) {
                return 0.0;
            }
            if (this.highCount == null || this.highCount < count) {
                volume *= 1.0;
            } else {
                double low = this.lowCount == null ? 0.0 : this.lowCount;
                volume *= (count - low) / (this.highCount - low);
            }
        }
        return volume;
    }

    public void onClientLoad() {
        if (this.blocks != null) {
            this.blocks.onClientLoad();
        }
        if (this.badBlocks != null) {
            this.badBlocks.onClientLoad();
        }
    }
}

