/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.env.pocket;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.env.pocket.AirPocket;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.common.util.type.list.SingletonList;
import team.creative.creativecore.common.util.type.map.HashMapDouble;
import team.creative.creativecore.common.util.type.set.QuadBitSet;

public class AirPocketScanner
extends Thread {
    public final AmbientEngine engine;
    public final Level level;
    public final BlockPos origin;
    private List<Collection<Pair<BlockPos, BlockPos>>> toScan = new ArrayList<Collection<Pair<BlockPos, BlockPos>>>();
    private final HashMapDouble<BlockState> foundPercentage = new HashMapDouble();
    private final HashMapDouble<BlockState> foundCount = new HashMapDouble();
    private QuadBitSet sky = new QuadBitSet();
    private double distributionCounter;
    private int totalSize = 0;
    private int currentDistance = 0;
    private int lightValueCounter = 0;
    private int skyLightValueCounter = 0;
    private int blocks = 0;
    private int air;
    private Consumer<AirPocket> consumer;

    public AirPocketScanner(AmbientEngine engine, Level level, BlockPos origin, Consumer<AirPocket> consumer) {
        this.origin = origin;
        this.engine = engine;
        this.level = level;
        this.consumer = consumer;
        this.start();
    }

    @Override
    public void run() {
        this.toScan.add((Collection<Pair<BlockPos, BlockPos>>)new SingletonList((Object)new Pair((Object)this.origin, (Object)this.origin)));
        while (this.currentDistance < this.toScan.size()) {
            for (Pair<BlockPos, BlockPos> pos : this.toScan.get(this.currentDistance)) {
                this.scan(this.level, this.currentDistance, (BlockPos)pos.key, (BlockPos)pos.value);
            }
            ++this.currentDistance;
        }
        this.foundCount.putAll(this.foundPercentage);
        this.foundPercentage.scale(1.0 / this.distributionCounter);
        this.consumer.accept(new AirPocket(this.engine, this.foundPercentage, this.foundCount, (double)this.lightValueCounter / (double)this.blocks, (double)this.skyLightValueCounter / (double)this.blocks, (double)this.air / (double)this.engine.maxAirPocketCount));
    }

    protected HashSet<Pair<BlockPos, BlockPos>> getOrCreate(int distance) {
        if (distance >= this.toScan.size()) {
            HashSet<Pair<BlockPos, BlockPos>> set = new HashSet<Pair<BlockPos, BlockPos>>();
            this.toScan.add(set);
            return set;
        }
        return (HashSet)this.toScan.get(distance);
    }

    protected void findState(BlockState state, int distance) {
        double factor = this.engine.airWeightFactor(distance);
        this.distributionCounter += factor;
        this.foundPercentage.put((Object)state, Double.valueOf(factor));
    }

    protected void scan(Level level, int distance, BlockPos pos, BlockPos from) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60795_() || !state.m_60838_((BlockGetter)level, pos)) {
            if (!state.m_60795_()) {
                this.findState(state, distance);
            }
            if (distance < this.engine.airPocketDistance && this.air < this.engine.maxAirPocketCount) {
                ++this.air;
            }
            ++distance;
            if (this.sky.get(pos.m_123341_(), pos.m_123343_()) && this.sky.get(pos.m_123341_() - 1, pos.m_123343_()) && this.sky.get(pos.m_123341_(), pos.m_123343_() - 1) && this.sky.get(pos.m_123341_() + 1, pos.m_123343_()) && this.sky.get(pos.m_123341_(), pos.m_123343_() + 1)) {
                return;
            }
            for (int i = 0; i < Direction.values().length; ++i) {
                if (this.totalSize > this.engine.airPocketCount) {
                    return;
                }
                Direction direction = Direction.values()[i];
                Direction.Axis axis = direction.m_122434_();
                if (direction.m_122421_() == Direction.AxisDirection.POSITIVE ? pos.m_123304_(axis) + 1 <= this.origin.m_123304_(axis) : pos.m_123304_(axis) - 1 >= this.origin.m_123304_(axis)) continue;
                this.getOrCreate(distance).add((Pair<BlockPos, BlockPos>)new Pair((Object)pos.m_142300_(direction), (Object)pos));
                ++this.totalSize;
            }
        } else {
            if (!this.sky.get(pos.m_123341_(), pos.m_123343_()) && level.m_45527_(pos.m_7494_())) {
                this.sky.set(pos.m_123341_(), pos.m_123343_());
                if (distance < this.engine.airPocketDistance) {
                    this.air = this.engine.maxAirPocketCount;
                }
            }
            this.lightValueCounter += level.m_7146_(from);
            this.skyLightValueCounter += level.m_45517_(LightLayer.SKY, from);
            ++this.blocks;
            this.findState(state, distance);
        }
    }
}

