/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonString;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldBounds;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.deposit.DepositGenResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;

public class Indicator
implements IHaveConfig {
    protected final UnitConfig config;
    protected final UnitId id;
    protected final List<Circle> circles;
    public final Percentage continuity;
    public final int distortion;

    public Indicator(UnitConfig config, String headCategory, String[] circles) {
        this.config = config;
        String category = this.expandClassCategory(headCategory);
        if (config != null) {
            config.setCategoryComment(category, "Aboveground indicator for this deposit (e.g., a rare flower or a combination of circles of different flowers)");
        }
        this.id = UnitConfig.getUnitId((UnitConfig)config, (String)category, (String)"id", (UnitId)UnitId.EMPTY, (String)"ID of the single-block indicator.");
        circles = UnitConfig.getStrArray((UnitConfig)config, (String)category, (String)"circles", (String[])circles, (String)"Circles of indicators and their radiuses.\nSyntax: indicatorId [, circleRadius]\nThe order of the circles is always shuffled.\nThe circles with the same radius will be randomly selected.\nIf the radius is not defined, it will be selected from the minimum available, starting from 1.\nExamples:\n     minecraft:cornflower, 2\n     minecraft:orange_tulip, 4\n");
        this.circles = Indicator.parseCirclesFrom(circles);
        this.continuity = UnitConfig.getPercentage((UnitConfig)config, (String)category, (String)"continuity", (Percentage)Percentage.value((float)60.0f), (FloatBounds)GameBounds.PERCENTAGE.getFloatBounds(), (String)"Percentage of the indicator shape that will be visible.");
        this.distortion = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"distortion", (int)1, (IntBounds)IntBounds.between((Integer)0, (Integer)16), (String)"Maximum displacement of the indicator shape elements.");
    }

    public static List<Circle> parseCirclesFrom(String[] array) {
        IntBounds radiusBounds = IntBounds.between((Integer)0, (Integer)256);
        ArrayList<Circle> circles = new ArrayList<Circle>();
        for (String str : array) {
            if ((str = str.trim()).isEmpty()) continue;
            String[] split = str.split(",");
            UnitId id = UnitId.from((String)split[0].trim());
            Integer radius = null;
            boolean error = id.isEmpty();
            if (split.length > 1) {
                try {
                    radius = Integer.parseInt(split[1].trim());
                    if (!radiusBounds.encloses(radius)) {
                        error = true;
                        AdLods.getInstance().getLogger().error("Circle radius out of " + radiusBounds);
                    }
                }
                catch (Exception e) {
                    error = true;
                }
            }
            if (!error) {
                if (id.getFirstMatchedState() == null) continue;
                circles.add(new Circle(id, Optional.ofNullable(radius)));
                continue;
            }
            AdLods.getInstance().getLogger().error("Unable to parse ore indicator from " + CommonString.quoted((String)str));
        }
        return circles;
    }

    public UnitId getCenterId() {
        return this.id;
    }

    public List<Circle> getCircles() {
        return this.circles;
    }

    public List<Circle> getShuffledCircles() {
        ArrayList<Circle> circles = new ArrayList<Circle>(this.getCircles());
        Collections.shuffle(circles);
        return circles;
    }

    public int placeFor(WorldGenLevel level, DepositGenResult result) {
        if (result.size < 1) {
            return 0;
        }
        if (this.getCenterId().isEmpty() && this.getCircles().isEmpty()) {
            return 0;
        }
        int count = 0;
        Optional centerPos = Optional.empty();
        BlockState indicator = this.id.getFirstMatchedState();
        int searchRadius = 4;
        if (indicator != null && (centerPos = this.findPositionFor(indicator, level, result.pos, searchRadius)).isPresent() && this.place(level, (BlockPos)centerPos.get(), indicator)) {
            ++count;
        }
        centerPos = centerPos.map(blockPos -> Optional.of(new BlockPos(blockPos.m_123341_(), result.pos.m_123342_(), blockPos.m_123343_()))).orElseGet(() -> Optional.of(result.pos));
        int defaultRadius = 1;
        HashSet<Integer> placedRadiuses = new HashSet<Integer>();
        List directions = GameWorld.Directions.of().horizontals().shuffle().toList();
        for (Circle circle : this.getShuffledCircles()) {
            BlockState indicator2 = circle.indicator.getFirstMatchedState();
            if (indicator2 == null) continue;
            int radius = circle.radius.orElse(defaultRadius);
            if (circle.radius.isPresent()) {
                if (placedRadiuses.contains(radius)) {
                    continue;
                }
            } else {
                while (placedRadiuses.contains(defaultRadius)) {
                    ++defaultRadius;
                }
                radius = defaultRadius;
            }
            for (BlockPos pos : this.getHorizCirclePoints((BlockPos)centerPos.get(), radius)) {
                if (!this.continuity.takeChance()) continue;
                Direction facing = CommonCollect.getRandomElementFrom((Collection)directions).orElse(null);
                if (facing != null) {
                    pos = pos.m_5484_(facing, CommonMath.Random.between((int)0, (int)this.distortion));
                }
                if ((pos = (BlockPos)this.findPositionFor(indicator2, level, pos, 0).orElse(null)) == null || !this.place(level, pos, indicator2)) continue;
                ++count;
            }
            placedRadiuses.add(radius);
        }
        return count;
    }

    protected boolean place(WorldGenLevel level, BlockPos pos, BlockState indicator) {
        int flags = 2;
        Block block = indicator.m_60734_();
        if (block instanceof DoublePlantBlock && level.m_46859_(pos.m_7494_())) {
            DoublePlantBlock.m_153173_((LevelAccessor)level, (BlockState)block.m_49966_(), (BlockPos)pos, (int)2);
            return true;
        }
        return level.m_7731_(pos, indicator, 2);
    }

    protected Optional<BlockPos> findPositionFor(BlockState indicator, WorldGenLevel level, BlockPos centerPos, int radius) {
        boolean hasCeiling = level.m_6042_().m_63946_();
        IntBounds boundsY = IntBounds.between((Integer)centerPos.m_123342_(), (Integer)WorldBounds.getHeightBounds((LevelHeightAccessor)level).getMax());
        for (int r = 0; r <= radius; ++r) {
            block1: for (BlockPos startPos : GameWorld.Positions.getAroundHoriz((BlockPos)centerPos, (int)r, (boolean)true)) {
                if (!GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)startPos) || !level.m_180807_(startPos)) continue;
                int startY = startPos.m_123342_();
                if (!hasCeiling) {
                    int oceanFloorY = level.m_6924_(Heightmap.Types.OCEAN_FLOOR, startPos.m_123341_(), startPos.m_123343_());
                    int worldSurfaceY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, startPos.m_123341_(), startPos.m_123343_());
                    startY = Math.min(oceanFloorY, worldSurfaceY);
                }
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(startPos.m_123341_(), startY, startPos.m_123343_());
                while (boundsY.encloses(Integer.valueOf(pos.m_123342_()))) {
                    BlockState state = level.m_8055_((BlockPos)pos);
                    if (state.m_60767_().m_76334_()) {
                        pos.m_122173_(Direction.UP);
                        continue;
                    }
                    if (!indicator.m_60710_((LevelReader)level, (BlockPos)pos)) continue block1;
                    Optional<BlockPos> placePos = Optional.of(pos.m_7949_());
                    FluidState fluidState = state.m_60819_();
                    if (!(indicator.m_60734_() instanceof LiquidBlockContainer ? fluidState.m_76153_((Tag)FluidTags.f_13131_) || indicator.m_60734_() instanceof SimpleWaterloggedBlock && fluidState.m_76178_() : fluidState.m_76178_())) continue block1;
                    return placePos;
                }
            }
        }
        return Optional.empty();
    }

    protected Set<BlockPos> getHorizCirclePoints(BlockPos centerPos, int radius) {
        HashSet<BlockPos> points = new HashSet<BlockPos>();
        Function<Integer, Integer> getOtherCoord = coord -> Mth.m_14143_((float)Mth.m_14116_((float)(radius * radius - coord * coord)));
        for (int dx = -radius; dx <= radius; ++dx) {
            int dz = getOtherCoord.apply(dx);
            points.add(centerPos.m_142082_(dx, 0, dz));
            points.add(centerPos.m_142082_(dx, 0, -dz));
        }
        for (int dz = -radius; dz <= radius; ++dz) {
            int dx = getOtherCoord.apply(dz);
            points.add(centerPos.m_142082_(dx, 0, dz));
            points.add(centerPos.m_142082_(-dx, 0, dz));
        }
        return points;
    }

    public UnitConfig getConfig() {
        return this.config;
    }

    protected static class Circle {
        public final UnitId indicator;
        public final Optional<Integer> radius;

        public Circle(UnitId indicator) {
            this(indicator, Optional.empty());
        }

        public Circle(UnitId indicator, int radius) {
            this(indicator, Optional.of(radius));
        }

        public Circle(UnitId indicator, Optional<Integer> radius) {
            this.indicator = indicator;
            this.radius = radius;
        }
    }
}

