/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blueprints.v1;

import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

public class BlueprintTagUtils {
    public static BlockPos getFirstPosForTag(Blueprint blueprint, String tagName) {
        BlockPos anchorPos = blueprint.getPrimaryBlockOffset();
        CompoundTag nbt = blueprint.getBlockInfoAsMap().get(anchorPos).getTileEntityData();
        if (nbt != null) {
            Map<BlockPos, List<String>> tagPosMap = IBlueprintDataProvider.readTagPosMapFrom(nbt.m_128469_("blueprintDataProvider"));
            for (Map.Entry<BlockPos, List<String>> entry : tagPosMap.entrySet()) {
                for (String tag : entry.getValue()) {
                    if (!tag.equals(tagName)) continue;
                    return entry.getKey();
                }
            }
        }
        return null;
    }

    public static int getNumberOfGroundLevels(@NotNull Blueprint blueprint, int defaultGroundLevels) {
        BlockPos groundLevelPos = BlueprintTagUtils.getFirstPosForTag(blueprint, "groundlevel");
        if (groundLevelPos != null) {
            return blueprint.getPrimaryBlockOffset().m_123342_() + groundLevelPos.m_123342_() + 1;
        }
        return defaultGroundLevels;
    }

    public static int getGroundAnchorOffset(@NotNull Blueprint blueprint, int defaultGroundOffset) {
        BlockPos groundLevelPos = BlueprintTagUtils.getFirstPosForTag(blueprint, "groundlevel");
        if (groundLevelPos != null) {
            return -groundLevelPos.m_123342_();
        }
        return defaultGroundOffset;
    }

    public static int getGroundAnchorOffsetFromGroundLevels(@NotNull Blueprint blueprint, int groundLevels) {
        return blueprint.getPrimaryBlockOffset().m_123342_() - groundLevels + 1;
    }
}

