/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockui.Loader;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonHandler;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.OverlayView;
import com.ldtteam.blockui.views.View;
import com.ldtteam.structurize.api.util.Log;
import java.util.function.ObjIntConsumer;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class DialogDoneCancel
extends OverlayView
implements ButtonHandler {
    public static final int CANCEL = 0;
    public static final int DONE = 1;
    private static final String DIALOG_OK_CANCEL_SUFFIX = ":gui/dialogdonecancel.xml";
    protected final Text titleLabel;
    protected final Text contentText;
    protected final Button doneButton;
    protected final Button cancelButton;
    protected ObjIntConsumer<DialogDoneCancel> handler;

    public DialogDoneCancel(BOWindow window) {
        this.putInside((View)window);
        this.setPosition(0, 0);
        this.setSize(window.getInteriorWidth(), window.getInteriorHeight());
        this.off();
        Loader.createFromXMLFile((ResourceLocation)new ResourceLocation("structurize:gui/dialogdonecancel.xml"), (View)this);
        this.titleLabel = (Text)this.findPaneOfTypeByID("title", Text.class);
        this.contentText = (Text)this.findPaneOfTypeByID("textcontent", Text.class);
        this.doneButton = (Button)this.findPaneOfTypeByID("done", Button.class);
        this.cancelButton = (Button)this.findPaneOfTypeByID("cancel", Button.class);
        this.doneButton.setHandler((ButtonHandler)this);
        this.cancelButton.setHandler((ButtonHandler)this);
    }

    public MutableComponent getTitleNew() {
        return this.titleLabel.getText();
    }

    public void setTitle(MutableComponent title) {
        this.titleLabel.setText(title);
    }

    public String getTextContent() {
        return this.contentText.getTextAsString();
    }

    public void setTextContent(MutableComponent content) {
        this.contentText.setText(content);
    }

    public void onButtonClicked(Button button) {
        this.close();
        if (this.handler == null) {
            Log.getLogger().error("DialogDoneCancel does not have a handler.");
            return;
        }
        if (button == this.doneButton) {
            this.handler.accept(this, 1);
        } else {
            this.handler.accept(this, 0);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.putInside(null);
        }
    }

    public void open() {
        this.on();
    }

    public void close() {
        this.off();
    }

    public void setHandler(ObjIntConsumer<DialogDoneCancel> h) {
        this.handler = h;
    }
}

