/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.controls.ToggleButton;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.blockui.views.View;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.api.util.Shape;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.client.gui.WindowReplaceBlock;
import com.ldtteam.structurize.client.gui.WindowUndoRedo;
import com.ldtteam.structurize.helpers.Settings;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.GenerateAndPasteMessage;
import com.ldtteam.structurize.network.messages.GenerateAndSaveMessage;
import com.ldtteam.structurize.network.messages.LSStructureDisplayerMessage;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.LanguageHandler;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.StructureUtils;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.Nullable;

public class WindowShapeTool
extends AbstractWindowSkeleton {
    private static final String RES_STRING = "textures/gui/buildtool/%s.png";
    private static final String GREEN_POS = "_green";
    private static final int POSSIBLE_ROTATIONS = 4;
    private static final String BUTTON_PASTE = "paste";
    private static final String BUTTON_MINUS = "minus";
    private static final String BUTTON_PLUS = "plus";
    private static final String IMAGE_ROTATION = "rotation";
    private final List<String> sections = new ArrayList<String>();
    private DropDownList sectionsDropDownList;
    private TextField inputWidth;
    private TextField inputLength;
    private TextField inputHeight;
    private TextField inputFrequency;
    private TextField inputShape;
    private int shapeWidth = 1;
    private int shapeLength = 1;
    private int shapeHeight = 1;
    private int shapeFrequency = 1;
    private String shapeEquation = "";
    private int rotation = 0;

    public WindowShapeTool(@Nullable BlockPos pos) {
        super("structurize:gui/windowshapetool.xml");
        this.init(pos, false);
    }

    private void init(BlockPos pos, boolean shouldUpdate) {
        if (!this.hasPermission()) {
            return;
        }
        @Nullable Blueprint structure = Settings.instance.getActiveStructure();
        if (structure != null) {
            this.rotation = Settings.instance.getRotation();
            this.shapeWidth = Settings.instance.getWidth();
            this.shapeLength = Settings.instance.getLength();
            this.shapeHeight = Settings.instance.getHeight();
            this.shapeFrequency = Settings.instance.getFrequency();
            this.shapeEquation = Settings.instance.getEquation();
        } else if (pos != null) {
            Settings.instance.setPosition(pos);
            Settings.instance.setRotation(0);
        }
        this.registerButton("confirm", this::confirmClicked);
        this.registerButton("cancel", this::cancelClicked);
        this.registerButton("left", this::moveLeftClicked);
        this.registerButton("mirror", this::mirror);
        this.registerButton("right", this::moveRightClicked);
        this.registerButton("down", this::moveBackClicked);
        this.registerButton("up", this::moveForwardClicked);
        this.registerButton(BUTTON_PLUS, WindowShapeTool::moveUpClicked);
        this.registerButton(BUTTON_MINUS, WindowShapeTool::moveDownClicked);
        this.registerButton("rotateRight", this::rotateRightClicked);
        this.registerButton("rotateLeft", this::rotateLeftClicked);
        this.registerButton("pickMainBlock", this::pickMainBlock);
        this.registerButton("pickFillBlock", this::pickFillBlock);
        this.registerButton("undoredo", (Button b) -> {
            this.close();
            new WindowUndoRedo().open();
        });
        this.registerButton("hollowShape", this::hollowShapeToggle);
        this.registerButton(BUTTON_PASTE, this::pasteClicked);
        this.inputWidth = (TextField)this.findPaneOfTypeByID("width", TextField.class);
        this.inputLength = (TextField)this.findPaneOfTypeByID("length", TextField.class);
        this.inputHeight = (TextField)this.findPaneOfTypeByID("height", TextField.class);
        this.inputFrequency = (TextField)this.findPaneOfTypeByID("frequency", TextField.class);
        this.inputShape = (TextField)this.findPaneOfTypeByID("shape", TextField.class);
        this.inputWidth.setText(Integer.toString(Settings.instance.getWidth()));
        this.inputLength.setText(Integer.toString(Settings.instance.getLength()));
        this.inputHeight.setText(Integer.toString(Settings.instance.getHeight()));
        this.inputFrequency.setText(Integer.toString(Settings.instance.getFrequency()));
        this.inputShape.setText(Settings.instance.getEquation());
        this.registerButton("widthminus", () -> this.adjust(this.inputWidth, Settings.instance.getWidth() - 1));
        this.registerButton("widthplus", () -> this.adjust(this.inputWidth, Settings.instance.getWidth() + 1));
        this.registerButton("lengthminus", () -> this.adjust(this.inputLength, Settings.instance.getLength() - 1));
        this.registerButton("lengthplus", () -> this.adjust(this.inputLength, Settings.instance.getLength() + 1));
        this.registerButton("heightminus", () -> this.adjust(this.inputHeight, Settings.instance.getHeight() - 1));
        this.registerButton("heightplus", () -> this.adjust(this.inputHeight, Settings.instance.getHeight() + 1));
        this.registerButton("frequencyminus", () -> this.adjust(this.inputFrequency, Settings.instance.getFrequency() - 1));
        this.registerButton("frequencyplus", () -> this.adjust(this.inputFrequency, Settings.instance.getFrequency() + 1));
        this.sections.clear();
        this.sections.addAll(Arrays.stream(Shape.values()).map(Enum::name).collect(Collectors.toList()));
        this.sectionsDropDownList = (DropDownList)this.findPaneOfTypeByID("style", DropDownList.class);
        this.sectionsDropDownList.setHandler(this::onDropDownListChanged);
        this.sectionsDropDownList.setDataProvider((DropDownList.DataProvider)new SectionDropDownList());
        this.sectionsDropDownList.setSelectedIndex(Settings.instance.getShape().ordinal());
        this.registerButton("nextShape", () -> ((DropDownList)this.sectionsDropDownList).selectNext());
        this.registerButton("previousShape", () -> ((DropDownList)this.sectionsDropDownList).selectPrevious());
        this.disableInputIfNecessary();
        if (structure == null || shouldUpdate) {
            WindowShapeTool.genShape();
        }
        this.updateRotationState();
        ((ToggleButton)this.findPaneOfTypeByID("hollowShape", ToggleButton.class)).setActiveState(Settings.instance.isHollow() ? "hollow" : "solid");
    }

    private static void genShape() {
        Settings.instance.setActiveSchematic(Manager.getStructureFromFormula(Settings.instance.getWidth(), Settings.instance.getLength(), Settings.instance.getHeight(), Settings.instance.getFrequency(), Settings.instance.getEquation(), Settings.instance.getShape(), Settings.instance.getBlock(true), Settings.instance.getBlock(false), Settings.instance.isHollow()));
    }

    public static void commonStructureUpdate() {
        WindowShapeTool.genShape();
        WindowShapeTool.updateRotation(Settings.instance.getRotation());
    }

    private void disableInputIfNecessary() {
        Shape shape = Settings.instance.getShape();
        View height = (View)this.findPaneOfTypeByID("heightInput", View.class);
        View width = (View)this.findPaneOfTypeByID("widthInput", View.class);
        View length = (View)this.findPaneOfTypeByID("lengthInput", View.class);
        View frequency = (View)this.findPaneOfTypeByID("frequencyInput", View.class);
        View equation = (View)this.findPaneOfTypeByID("shapeInput", View.class);
        height.show();
        width.show();
        length.show();
        frequency.show();
        equation.hide();
        this.findPaneByID("hollowShape").show();
        this.findPaneByID("pickFillBlock").show();
        this.findPaneByID("resourceIconFill").show();
        if (shape == Shape.SPHERE || shape == Shape.HALF_SPHERE || shape == Shape.BOWL || shape == Shape.PYRAMID || shape == Shape.UPSIDE_DOWN_PYRAMID || shape == Shape.DIAMOND) {
            width.hide();
            length.hide();
            frequency.hide();
        } else if (shape == Shape.CYLINDER || shape == Shape.CONE) {
            length.hide();
            frequency.hide();
        } else if (shape != Shape.WAVE && shape != Shape.WAVE_3D) {
            frequency.hide();
        }
    }

    private void pickMainBlock() {
        new WindowReplaceBlock(Settings.instance.getBlock(true), Settings.instance.getPosition(), true, (BOWindow)this).open();
    }

    private void pickFillBlock() {
        new WindowReplaceBlock(Settings.instance.getBlock(false), Settings.instance.getPosition(), false, (BOWindow)this).open();
    }

    private void adjust(TextField input, int value) {
        input.setText(Integer.toString(Math.max(1, value)));
        this.onKeyTyped('\u0000', 0);
    }

    private void replaceBlocksToggle() {
        Button replaceButton = (Button)this.findPaneOfTypeByID("replaceBlocks", Button.class);
        if (replaceButton.getTextAsString().equalsIgnoreCase(new TranslatableComponent("com.ldtteam.structurize.gui.shapetool.replace").getString())) {
            replaceButton.setText((MutableComponent)new TranslatableComponent("com.ldtteam.structurize.gui.shapetool.ignore"));
        } else if (replaceButton.getTextAsString().equalsIgnoreCase(new TranslatableComponent("com.ldtteam.structurize.gui.shapetool.ignore").getString())) {
            replaceButton.setText((MutableComponent)new TranslatableComponent("com.ldtteam.structurize.gui.shapetool.replace"));
        }
    }

    private void hollowShapeToggle() {
        ToggleButton hollowButton = (ToggleButton)this.findPaneOfTypeByID("hollowShape", ToggleButton.class);
        Settings.instance.setHollow(hollowButton.isActiveState("hollow"));
        WindowShapeTool.genShape();
    }

    private void confirmClicked() {
        this.place();
        this.clearAndClose();
    }

    private void pasteClicked() {
        if (this.isCreative()) {
            this.paste();
        }
        this.clearAndClose();
    }

    protected void place() {
        if (this.isCreative()) {
            this.paste();
        }
    }

    protected StructureName save() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        BlueprintUtil.writeToStream(stream, Settings.instance.getActiveStructure());
        Structures.handleSaveSchematicMessage(stream.toByteArray(), true);
        if (!Minecraft.m_91087_().m_91091_()) {
            Network.getNetwork().sendToServer(new GenerateAndSaveMessage(Settings.instance.getPosition(), Settings.instance.getLength(), Settings.instance.getWidth(), Settings.instance.getHeight(), Settings.instance.getFrequency(), Settings.instance.getEquation(), Settings.instance.getShape(), Settings.instance.getBlock(true), Settings.instance.getBlock(false), Settings.instance.isHollow(), BlockUtils.getRotation(Settings.instance.getRotation()), Settings.instance.getMirror()));
        }
        return new StructureName("cache/" + StructureUtils.calculateMD5(stream.toByteArray()));
    }

    private void paste() {
        Network.getNetwork().sendToServer(new GenerateAndPasteMessage(Settings.instance.getPosition(), Settings.instance.getLength(), Settings.instance.getWidth(), Settings.instance.getHeight(), Settings.instance.getFrequency(), Settings.instance.getEquation(), Settings.instance.getShape(), Settings.instance.getBlock(true), Settings.instance.getBlock(false), Settings.instance.isHollow(), BlockUtils.getRotation(Settings.instance.getRotation()), Settings.instance.getMirror()));
    }

    private void mirror() {
        Settings.instance.mirror();
        this.updateRotationState();
    }

    public void onOpened() {
        if (!this.hasPermission()) {
            LanguageHandler.sendMessageToPlayer((Player)Minecraft.m_91087_().f_91074_, "structurize.gui.shapetool.creative_only", new Object[0]);
            this.close();
        }
        ((ItemIcon)this.findPaneOfTypeByID("resourceIconMain", ItemIcon.class)).setItem(Settings.instance.getBlock(true));
        ((ItemIcon)this.findPaneOfTypeByID("resourceIconFill", ItemIcon.class)).setItem(Settings.instance.getBlock(false));
        ((Button)this.findPaneOfTypeByID("undoredo", Button.class)).setVisible(this.isCreative());
        ((Button)this.findPaneOfTypeByID(BUTTON_PASTE, Button.class)).setVisible(this.isCreative());
    }

    public void updateBlock(ItemStack stack, boolean mainBlock) {
        Settings.instance.setBlock(stack, mainBlock);
        ((ItemIcon)this.findPaneOfTypeByID(mainBlock ? "resourceIconMain" : "resourceIconFill", ItemIcon.class)).setItem(stack);
        WindowShapeTool.genShape();
    }

    public boolean isCreative() {
        return Minecraft.m_91087_().f_91074_.m_7500_();
    }

    public boolean hasPermission() {
        return this.isCreative();
    }

    private void onDropDownListChanged(DropDownList list) {
        if (list == this.sectionsDropDownList) {
            this.updateStyle(this.sections.get(this.sectionsDropDownList.getSelectedIndex()));
        }
    }

    private void updateStyle(String s) {
        if (Shape.valueOf(this.sections.get(this.sectionsDropDownList.getSelectedIndex())) != Settings.instance.getShape()) {
            Settings.instance.setShape(s);
            WindowShapeTool.genShape();
        }
        this.disableInputIfNecessary();
    }

    public boolean onKeyTyped(char ch, int key) {
        boolean result = super.onKeyTyped(ch, key);
        String widthText = this.inputWidth.getText();
        String lengthText = this.inputLength.getText();
        String heightText = this.inputHeight.getText();
        String frequencyText = this.inputFrequency.getText();
        String localEquation = this.inputShape.getText();
        if (!(widthText.isEmpty() || lengthText.isEmpty() || heightText.isEmpty())) {
            try {
                int localWidth = Integer.parseInt(widthText);
                int localHeight = Integer.parseInt(heightText);
                int localLength = Integer.parseInt(lengthText);
                int localFrequency = Integer.parseInt(frequencyText);
                if (this.shapeHeight != localHeight || this.shapeLength != localLength || this.shapeWidth != localWidth || this.shapeFrequency != localFrequency || !this.shapeEquation.equals(localEquation)) {
                    this.shapeWidth = localWidth;
                    this.shapeLength = localLength;
                    this.shapeHeight = localHeight;
                    this.shapeFrequency = localFrequency;
                    this.shapeEquation = localEquation;
                    Settings.instance.setWidth(localWidth);
                    Settings.instance.setLength(localLength);
                    Settings.instance.setHeight(localHeight);
                    Settings.instance.setFrequency(localFrequency);
                    Settings.instance.setEquation(localEquation);
                    WindowShapeTool.genShape();
                }
            }
            catch (NumberFormatException e) {
                this.inputWidth.setText(Integer.toString(Settings.instance.getWidth()));
                this.inputLength.setText(Integer.toString(Settings.instance.getLength()));
                this.inputHeight.setText(Integer.toString(Settings.instance.getHeight()));
            }
        }
        return result;
    }

    private static void moveUpClicked() {
        Settings.instance.moveTo(new BlockPos(0, 1, 0));
    }

    private static void moveDownClicked() {
        Settings.instance.moveTo(new BlockPos(0, -1, 0));
    }

    private void moveLeftClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).m_142300_(this.mc.f_91074_.m_6350_().m_122428_()));
    }

    private void moveRightClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).m_142300_(this.mc.f_91074_.m_6350_().m_122427_()));
    }

    private void moveForwardClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).m_142300_(this.mc.f_91074_.m_6350_()));
    }

    private void moveBackClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).m_142300_(this.mc.f_91074_.m_6350_().m_122424_()));
    }

    private void rotateRightClicked() {
        this.rotation = (this.rotation + 1) % 4;
        WindowShapeTool.updateRotation(this.rotation);
        this.updateRotationState();
    }

    private void rotateLeftClicked() {
        this.rotation = (this.rotation + 3) % 4;
        WindowShapeTool.updateRotation(this.rotation);
        this.updateRotationState();
    }

    private void clearAndClose() {
        Settings.instance.resetBlueprint();
        Network.getNetwork().sendToServer(new LSStructureDisplayerMessage(null, false));
        this.close();
    }

    private void cancelClicked() {
        this.clearAndClose();
    }

    private static void updateRotation(int rotation) {
        PlacementSettings settings = new PlacementSettings();
        switch (rotation) {
            case 1: {
                settings.setRotation(Rotation.CLOCKWISE_90);
                break;
            }
            case 2: {
                settings.setRotation(Rotation.CLOCKWISE_180);
                break;
            }
            case 3: {
                settings.setRotation(Rotation.COUNTERCLOCKWISE_90);
                break;
            }
            default: {
                settings.setRotation(Rotation.NONE);
            }
        }
        Settings.instance.setRotation(rotation);
        settings.setMirror(Settings.instance.getMirror());
    }

    private void updateRotationState() {
        ((ButtonImage)this.findPaneOfTypeByID("mirror", ButtonImage.class)).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "mirror" + (Settings.instance.getMirror().equals((Object)Mirror.NONE) ? "" : GREEN_POS))), false);
        ((Image)this.findPaneOfTypeByID(IMAGE_ROTATION, Image.class)).setImage(new ResourceLocation("structurize", String.format(RES_STRING, switch (Settings.instance.getRotation()) {
            case 1 -> "right_green";
            case 2 -> "down_green";
            case 3 -> "left_green";
            default -> "up_green";
        })), false);
    }

    public void onClosed() {
        if (Settings.instance.getActiveStructure() != null) {
            Network.getNetwork().sendToServer(new LSStructureDisplayerMessage(Settings.instance.serializeNBT(), true));
        }
    }

    private class SectionDropDownList
    implements DropDownList.DataProvider {
        private SectionDropDownList() {
        }

        public int getElementCount() {
            return WindowShapeTool.this.sections.size();
        }

        public String getLabel(int index) {
            return WindowShapeTool.this.sections.get(index);
        }
    }
}

