/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonHandler;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.helpers.Settings;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import net.minecraft.resources.ResourceLocation;

public class WindowStructureNameEntry
extends BOWindow
implements ButtonHandler {
    private static final String BUTTON_DONE = "done";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String INPUT_NAME = "name";
    private static final String STRUCTURE_NAME_RESOURCE_SUFFIX = ":gui/windowstructurenameentry.xml";
    private final StructureName structureName;
    private final TextField inputName;

    public WindowStructureNameEntry(StructureName s) {
        super(new ResourceLocation("structurize:gui/windowstructurenameentry.xml"));
        this.structureName = s;
        this.inputName = (TextField)this.findPaneOfTypeByID(INPUT_NAME, TextField.class);
    }

    public void onOpened() {
        this.inputName.setText(this.structureName.getStyle() + "/" + this.structureName.getSchematic());
    }

    public void onButtonClicked(Button button) {
        if (button.getID().equals(BUTTON_DONE)) {
            StructureName newStructureName;
            String name = this.inputName.getText();
            if (!name.isEmpty() && (newStructureName = Structures.renameScannedStructure(this.structureName, name)) != null) {
                Settings.instance.setStructureName(newStructureName.toString());
            }
        } else if (!button.getID().equals(BUTTON_CANCEL)) {
            return;
        }
        this.close();
        Structurize.proxy.openBuildToolWindow(null, 1);
    }
}

