/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.management.linksession.LinkSessionManager;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public final class BackUpHelper {
    private static final String FILENAME_EXT_OLD = ".old";
    private static final String FILENAME_EXT_DAT = ".dat";
    private static final String FILENAME_STRUCTURIZE_PATH = "structurize";
    private static final String FILENAME_LINKSESSION = "_linksession";
    private static final DateTimeFormatter BACKUP_TIMESTAMP = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH.mm.ss");

    private BackUpHelper() {
    }

    public static void saveLinkSessionManager() {
        CompoundTag data = LinkSessionManager.INSTANCE.serializeNBT();
        File file = BackUpHelper.getSaveLocation(FILENAME_LINKSESSION);
        BackUpHelper.cycleNewBackup(FILENAME_LINKSESSION, 2);
        BackUpHelper.saveNBTToPath(file, data);
    }

    public static void loadLinkSessionManager() {
        File file = BackUpHelper.getSaveLocation(FILENAME_LINKSESSION);
        CompoundTag data = BackUpHelper.loadNBTFromPath(file);
        if (data != null) {
            LinkSessionManager.INSTANCE.deserializeNBT(data);
        }
    }

    private static void cycleNewBackup(String additionalPath, int cycleUpToNFiles) {
        File current = BackUpHelper.getSaveLocation(additionalPath);
        File newBackup = BackUpHelper.getBackupSaveLocation(additionalPath, LocalDateTime.now());
        if (!current.exists() || BackUpHelper.getSaveDir().list() == null) {
            return;
        }
        current.renameTo(newBackup);
        Supplier<Stream> allBackups = () -> Stream.of(BackUpHelper.getSaveDir().list()).filter(fileName -> fileName.contains(FILENAME_EXT_OLD) && fileName.contains(FILENAME_STRUCTURIZE_PATH + additionalPath));
        if (allBackups.get().count() > (long)cycleUpToNFiles) {
            AtomicInteger toRemove = new AtomicInteger((int)allBackups.get().count() - cycleUpToNFiles);
            allBackups.get().map(fileName -> BackUpHelper.getTimestampFromBackup(additionalPath, fileName)).sorted().filter(a -> toRemove.getAndDecrement() > 0).map(datetime -> BackUpHelper.getBackupSaveLocation(additionalPath, datetime)).forEach(fileToRemove -> fileToRemove.delete());
        }
    }

    private static File getSaveDir() {
        return ServerLifecycleHooks.getCurrentServer().m_129843_(new LevelResource(FILENAME_STRUCTURIZE_PATH)).toFile();
    }

    private static File getSaveLocation(String additionalPath) {
        return new File(BackUpHelper.getSaveDir(), FILENAME_STRUCTURIZE_PATH + additionalPath + FILENAME_EXT_DAT);
    }

    private static File getBackupSaveLocation(String additionalPath, LocalDateTime date) {
        return new File(BackUpHelper.getSaveDir(), String.format(FILENAME_STRUCTURIZE_PATH + additionalPath + "-%s.dat.old", BACKUP_TIMESTAMP.format(date)));
    }

    private static LocalDateTime getTimestampFromBackup(String additionalPath, String fileName) {
        return LocalDateTime.parse(fileName.replace(FILENAME_STRUCTURIZE_PATH + additionalPath + "-", "").replace(".dat.old", ""), BACKUP_TIMESTAMP);
    }

    public static void saveNBTToPath(@Nullable File file, CompoundTag compound) {
        try {
            if (file != null) {
                file.getParentFile().mkdir();
                BackUpHelper.safeWrite(compound, file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when saving data into external file!", (Throwable)exception);
        }
    }

    public static CompoundTag loadNBTFromPath(@Nullable File file) {
        try {
            if (file != null && file.exists()) {
                return NbtIo.m_128953_((File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when loading data from external file!", (Throwable)exception);
        }
        return null;
    }

    public static void safeWrite(CompoundTag compound, File fileIn) throws IOException {
        File file1 = new File(fileIn.getAbsolutePath() + "_tmp");
        if (file1.exists()) {
            file1.delete();
        }
        NbtIo.m_128955_((CompoundTag)compound, (File)file1);
        if (fileIn.exists()) {
            fileIn.delete();
        }
        if (fileIn.exists()) {
            throw new IOException("Failed to delete " + fileIn);
        }
        file1.renameTo(fileIn);
    }
}

