/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.java.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import mod.lucky.common.Logger;
import mod.lucky.common.LoggerKt;
import mod.lucky.common.attribute.ParserKt;
import mod.lucky.common.drop.WeightedDrop;
import mod.lucky.common.drop.WeightedDropKt;
import mod.lucky.java.Addon;
import mod.lucky.java.AddonIds;
import mod.lucky.java.JavaGameAPIKt;
import mod.lucky.java.JavaLuckyRegistry;
import mod.lucky.java.loader.AddonResources;
import mod.lucky.java.loader.GlobalSettings;
import mod.lucky.java.loader.LocalSettings;
import mod.lucky.java.loader.MainResources;
import mod.lucky.java.loader.ReadCraftingKt;
import mod.lucky.java.loader.ReadSettingsKt;
import mod.lucky.java.loader.ReadStructuresKt;
import mod.lucky.java.loader.ReadWorldGenDropsKt;
import mod.lucky.java.loader.StructureResource;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.jetbrains.annotations.Nullable;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.Pair;
import mod.lucky.kotlin.TuplesKt;
import mod.lucky.kotlin.collections.ArraysKt;
import mod.lucky.kotlin.collections.CollectionsKt;
import mod.lucky.kotlin.collections.MapsKt;
import mod.lucky.kotlin.io.FilesKt;
import mod.lucky.kotlin.jvm.functions.Function0;
import mod.lucky.kotlin.jvm.internal.Intrinsics;
import mod.lucky.kotlin.sequences.SequencesKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00012\u0006\u0010\n\u001a\u00020\b\u001a\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b\u001a\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0002\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\b\u001a\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b\u001a \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00010\u00162\u0006\u0010\n\u001a\u00020\b\u001a\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001b\u001a\u00020\r\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001c"}, d2={"commonConfigFiles", "", "", "getCommonConfigFiles", "()Ljava/util/List;", "extractDefaultConfig", "", "configDir", "Ljava/io/File;", "findAddonsOrMakeDir", "gameDir", "getConfigDir", "getInputStream", "Ljava/io/InputStream;", "baseDir", "path", "loadAddonResources", "Lmod/lucky/java/loader/AddonResources;", "addonFile", "loadMainResources", "Lmod/lucky/java/loader/MainResources;", "loadResources", "Lmod/lucky/kotlin/Pair;", "parseDrops", "Lmod/lucky/common/drop/WeightedDrop;", "lines", "readLines", "stream", "common"})
public final class LoaderKt {
    @NotNull
    private static final List<String> commonConfigFiles;

    @NotNull
    public static final List<String> getCommonConfigFiles() {
        return commonConfigFiles;
    }

    @Nullable
    public static final InputStream getInputStream(@NotNull File baseDir, @NotNull String path) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter(baseDir, "baseDir");
        Intrinsics.checkNotNullParameter(path, "path");
        if (baseDir.isDirectory()) {
            File file = new File(baseDir + '/' + path);
            inputStream = file.exists() && !file.isDirectory() ? new FileInputStream(file) : null;
        } else {
            ZipEntry zipEntry;
            ZipFile file;
            block3: {
                file = new ZipFile(baseDir);
                Enumeration<? extends ZipEntry> enumeration = file.entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, "file.entries()");
                Iterator<? extends ZipEntry> iterator2 = SequencesKt.asSequence(CollectionsKt.iterator(enumeration)).iterator();
                while (iterator2.hasNext()) {
                    ZipEntry zipEntry2;
                    ZipEntry it = zipEntry2 = iterator2.next();
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getName(), path)) continue;
                    zipEntry = zipEntry2;
                    break block3;
                }
                zipEntry = null;
            }
            ZipEntry entry = zipEntry;
            inputStream = entry != null && !entry.isDirectory() ? file.getInputStream(entry) : null;
        }
        return inputStream;
    }

    @NotNull
    public static final List<String> readLines(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream));
        return SequencesKt.toList(SequencesKt.generateSequence((Function0)new Function0<String>(bufferedReader){
            final /* synthetic */ BufferedReader $bufferedReader;
            {
                this.$bufferedReader = $bufferedReader;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return this.$bufferedReader.readLine();
            }
        }));
    }

    @NotNull
    public static final File getConfigDir(@NotNull File gameDir) {
        Intrinsics.checkNotNullParameter(gameDir, "gameDir");
        return FilesKt.resolve(gameDir, "config/lucky/" + JavaGameAPIKt.getJAVA_GAME_API().getModVersion() + '-' + JavaGameAPIKt.getJAVA_GAME_API().getLoaderName());
    }

    @NotNull
    public static final List<WeightedDrop> parseDrops(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        List<String> newLines = ParserKt.splitLines(lines);
        return WeightedDropKt.dropsFromStrList(newLines);
    }

    public static final void extractDefaultConfig(@NotNull File configDir) {
        Intrinsics.checkNotNullParameter(configDir, "configDir");
        try {
            InputStream stream = JavaLuckyRegistry.class.getResourceAsStream("lucky-config.zip");
            if (stream == null) {
                LoggerKt.getLOGGER().logInfo("No default resources found. Ignore this in a dev environment.");
                return;
            }
            ZipInputStream inputStream = new ZipInputStream(stream);
            Iterator iterator2 = SequencesKt.generateSequence((Function0)new Function0<ZipEntry>(inputStream){
                final /* synthetic */ ZipInputStream $inputStream;
                {
                    this.$inputStream = $inputStream;
                    super(0);
                }

                @Nullable
                public final ZipEntry invoke() {
                    return this.$inputStream.getNextEntry();
                }
            }).iterator();
            while (iterator2.hasNext()) {
                ZipEntry entry = (ZipEntry)iterator2.next();
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue(string, "entry.name");
                File dest = FilesKt.resolve(configDir, string);
                if (entry.isDirectory() || dest.exists()) continue;
                if (!dest.getParentFile().exists()) {
                    dest.getParentFile().mkdirs();
                }
                dest.createNewFile();
                FileOutputStream outputStream = new FileOutputStream(dest);
                Iterator iterator3 = SequencesKt.generateSequence((Function0)new Function0<Integer>(inputStream){
                    final /* synthetic */ ZipInputStream $inputStream;
                    {
                        this.$inputStream = $inputStream;
                        super(0);
                    }

                    @Nullable
                    public final Integer invoke() {
                        int it = this.$inputStream.read();
                        boolean bl = false;
                        return it == -1 ? null : Integer.valueOf(it);
                    }
                }).iterator();
                while (iterator3.hasNext()) {
                    int dataByte = ((Number)iterator3.next()).intValue();
                    outputStream.write(dataByte);
                }
                outputStream.close();
            }
            inputStream.close();
        }
        catch (Exception e) {
            LoggerKt.getLOGGER().logError("Error extracting default config", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MainResources loadMainResources(@NotNull File configDir) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(configDir, "configDir");
        Iterable $this$map$iv = commonConfigFiles;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair<void, List<String>> pair;
            void path;
            String string = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            InputStream stream = LoaderKt.getInputStream(configDir, (String)path);
            if (stream == null) {
                Logger.DefaultImpls.logError$default(LoggerKt.getLOGGER(), "Missing resource '" + (String)path + "' in " + configDir.getPath(), null, 2, null);
                pair = TuplesKt.to(path, CollectionsKt.emptyList());
            } else {
                pair = TuplesKt.to(path, LoaderKt.readLines(stream));
            }
            object.add(pair);
        }
        Map fileContents = MapsKt.toMap((List)destination$iv$iv);
        Pair[] $i$f$map22 = new Pair[]{TuplesKt.to("lucky:lucky_block", "drops.txt"), TuplesKt.to("lucky:lucky_sword", "sword_drops.txt"), TuplesKt.to("lucky:lucky_bow", "bow_drops.txt"), TuplesKt.to("lucky:lucky_potion", "potion_drops.txt")};
        Map $this$mapValues$iv = MapsKt.mapOf($i$f$map22);
        boolean $i$f$mapValues = false;
        destination$iv$iv = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            List<WeightedDrop> list;
            void $dstr$_u24__u24$v;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = map;
            boolean bl2 = false;
            String v = (String)$dstr$_u24__u24$v.getValue();
            if ((List)fileContents.get(v) == null) {
                list = null;
            } else {
                List it;
                boolean bl3 = false;
                list = LoaderKt.parseDrops(it);
            }
            List<WeightedDrop> list2 = list;
            if (list == null) {
                list2 = CollectionsKt.emptyList();
            }
            List<WeightedDrop> list3 = list2;
            object.put(k, list3);
        }
        Map drops = destination$iv$iv2;
        Object v = fileContents.get("properties.txt");
        Intrinsics.checkNotNull(v);
        GlobalSettings globalSettings = ReadSettingsKt.parseGlobalSettings((List)v);
        Object v2 = fileContents.get("properties.txt");
        Intrinsics.checkNotNull(v2);
        LocalSettings localSettings = ReadSettingsKt.parseLocalSettings((List)v2);
        Object v3 = fileContents.get("natural_gen.txt");
        Intrinsics.checkNotNull(v3);
        Map<String, List<WeightedDrop>> map = ReadWorldGenDropsKt.readWorldGenDrops((List)v3);
        Object v4 = fileContents.get("luck_crafting.txt");
        Intrinsics.checkNotNull(v4);
        Map<String, Integer> map2 = ReadCraftingKt.readCraftingLuckModifiers((List)v4);
        Object v5 = fileContents.get("structures.txt");
        Intrinsics.checkNotNull(v5);
        Map<String, StructureResource> map3 = ReadStructuresKt.readStructures(configDir, (List)v5);
        return new MainResources(globalSettings, localSettings, drops, map, map3, map2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final AddonResources loadAddonResources(@NotNull File addonFile) {
        List<Object> list;
        Map<String, Integer> map;
        Map<String, List<WeightedDrop>> map2;
        LocalSettings localSettings;
        Map map3;
        Map<String, StructureResource> map4;
        Map<Object, Object> map5;
        void $this$mapValuesTo$iv$iv;
        Pair<Object, String> pair;
        Pair<Object, String> pair2;
        Pair<Object, String> pair3;
        Object object;
        String it;
        int n;
        Pair<void, String> pair4;
        Object object2;
        Pair[] $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(addonFile, "addonFile");
        String[] stringArray = new String[]{"plugin_init.txt", "recipes.txt"};
        List configFiles = CollectionsKt.plus((Collection)commonConfigFiles, (Iterable)CollectionsKt.listOf(stringArray));
        Iterable $this$map$iv = configFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Pair[] destination$iv$iv = (Pair[])new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo232 = false;
        for (Object t : $this$mapTo$iv$iv) {
            Pair<void, List<String>> pair5;
            void path;
            String string = (String)t;
            object2 = destination$iv$iv;
            boolean bl = false;
            InputStream stream = LoaderKt.getInputStream(addonFile, (String)path);
            if (stream == null) {
                if (Intrinsics.areEqual(path, "plugin_init.txt")) {
                    Logger.DefaultImpls.logError$default(LoggerKt.getLOGGER(), "Missing resource '" + (String)path + "' for addon '" + addonFile.getName() + '\'', null, 2, null);
                    return null;
                }
                pair5 = TuplesKt.to(path, CollectionsKt.emptyList());
            } else {
                pair5 = TuplesKt.to(path, LoaderKt.readLines(stream));
            }
            object2.add(pair5);
        }
        Map fileContents = MapsKt.toMap((List)destination$iv$iv);
        Object v = fileContents.get("plugin_init.txt");
        Intrinsics.checkNotNull(v);
        AddonIds addonIds = ReadSettingsKt.readAddonIds((List)v);
        Pair[] pairArray = $this$mapTo$iv$iv = new Pair[4];
        int n2 = 0;
        String string = addonIds.getBlock();
        if (string == null) {
            pair4 = null;
        } else {
            String string2 = string;
            n = n2;
            object2 = pairArray;
            boolean bl = false;
            object = TuplesKt.to(it, "drops.txt");
            pairArray = object2;
            n2 = n;
            pair4 = object;
        }
        pairArray[n2] = pair4;
        Pair[] pairArray2 = $this$mapTo$iv$iv;
        int n3 = 1;
        String string2 = addonIds.getSword();
        if (string2 == null) {
            pair3 = null;
        } else {
            it = string2;
            n = n3;
            object2 = pairArray2;
            boolean bl = false;
            object = TuplesKt.to(it, "sword_drops.txt");
            pairArray2 = object2;
            n3 = n;
            pair3 = object;
        }
        pairArray2[n3] = pair3;
        Pair[] pairArray3 = $this$mapTo$iv$iv;
        int n4 = 2;
        String string3 = addonIds.getBow();
        if (string3 == null) {
            pair2 = null;
        } else {
            it = string3;
            n = n4;
            object2 = pairArray3;
            boolean bl = false;
            object = TuplesKt.to(it, "bow_drops.txt");
            pairArray3 = object2;
            n4 = n;
            pair2 = object;
        }
        pairArray3[n4] = pair2;
        Pair[] pairArray4 = $this$mapTo$iv$iv;
        int n5 = 3;
        String string4 = addonIds.getPotion();
        if (string4 == null) {
            pair = null;
        } else {
            it = string4;
            n = n5;
            object2 = pairArray4;
            boolean bl = false;
            object = TuplesKt.to(it, "potion_drops.txt");
            pairArray4 = object2;
            n5 = n;
            pair = object;
        }
        pairArray4[n5] = pair;
        Map $this$mapValues$iv = MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull($this$mapTo$iv$iv));
        boolean $i$f$mapValues = false;
        Map $i$f$mapTo232 = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean bl = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $dstr$_u24__u24$v;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map6 = destination$iv$iv2;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object2 = map6;
            boolean bl22 = false;
            String v2 = (String)$dstr$_u24__u24$v.getValue();
            Object v3 = fileContents.get(v2);
            Intrinsics.checkNotNull(v3);
            object = LoaderKt.parseDrops((List)v3);
            object2.put(k, object);
        }
        Map drops = destination$iv$iv2;
        String[] stringArray2 = new String[]{addonIds.getBlock(), addonIds.getSword(), addonIds.getBow(), addonIds.getPotion()};
        String addonId = CollectionsKt.first(CollectionsKt.listOfNotNull(stringArray2));
        Object object3 = new Addon(addonIds, addonFile, addonId);
        Object v4 = fileContents.get("properties.txt");
        Intrinsics.checkNotNull(v4);
        LocalSettings localSettings2 = ReadSettingsKt.parseLocalSettings((List)v4);
        Map map6 = drops;
        List list2 = (List)fileContents.get("structures.txt");
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Map<String, StructureResource> map7 = ReadStructuresKt.readStructures(addonFile, list2);
        List list3 = (List)fileContents.get("natural_gen.txt");
        if (list3 == null) {
            map5 = null;
        } else {
            List list4 = list3;
            map4 = map7;
            map3 = map6;
            localSettings = localSettings2;
            object = object3;
            boolean bl3 = false;
            map2 = ReadWorldGenDropsKt.readWorldGenDrops(list4);
            object3 = object;
            localSettings2 = localSettings;
            map6 = map3;
            map7 = map4;
            map5 = map2;
        }
        Map<Object, Object> map8 = map5;
        if (map5 == null) {
            map8 = MapsKt.emptyMap();
        }
        List list5 = (List)fileContents.get("luck_crafting.txt");
        if (list5 == null) {
            map = null;
        } else {
            List list6 = list5;
            map2 = map8;
            map4 = map7;
            map3 = map6;
            localSettings = localSettings2;
            object = object3;
            boolean bl4 = false;
            Map<String, Integer> map10 = ReadCraftingKt.readCraftingLuckModifiers(list6);
            object3 = object;
            localSettings2 = localSettings;
            map6 = map3;
            map7 = map4;
            map8 = map2;
            map = map10;
        }
        Map<String, Integer> map9 = map;
        if (map == null) {
            map9 = MapsKt.emptyMap();
        }
        if (addonIds.getBlock() != null && fileContents.containsKey("recipes.txt")) {
            Object v5 = fileContents.get("recipes.txt");
            Intrinsics.checkNotNull(v5);
            list = ReadCraftingKt.readAddonCraftingRecipes((List)v5, addonIds.getBlock());
        } else {
            list = CollectionsKt.emptyList();
        }
        List list52 = list;
        Map<String, Integer> map12 = map9;
        Map map13 = map8;
        Map<String, StructureResource> map14 = map7;
        Map map15 = map6;
        LocalSettings localSettings3 = localSettings2;
        Object object4 = object3;
        return new AddonResources((Addon)object4, localSettings3, map15, map14, map13, map12, list52);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final List<File> findAddonsOrMakeDir(@NotNull File gameDir) {
        block8: {
            block9: {
                block7: {
                    Intrinsics.checkNotNullParameter(gameDir, "gameDir");
                    addonsDirV1 = FilesKt.resolve(gameDir, "addons/luckyBlock");
                    addonsDirV2 = FilesKt.resolve(gameDir, "addons/lucky");
                    if (addonsDirV2.exists()) {
                        v0 = addonsDirV2;
                    } else if (addonsDirV1.exists()) {
                        v0 = addonsDirV1;
                    } else {
                        addonsDirV2.mkdirs();
                        return CollectionsKt.emptyList();
                    }
                    addonsDir = v0;
                    v1 = addonsDir.listFiles();
                    if (v1 != null) break block7;
                    v2 = null;
                    break block8;
                }
                v3 = ArraysKt.toList(v1);
                if (v3 != null) break block9;
                v2 = null;
                break block8;
            }
            $this$filter$iv = v3;
            $i$f$filter = false;
            var7_6 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (File)element$iv$iv;
                $i$a$-filter-LoaderKt$findAddonsOrMakeDir$1 = false;
                if (it.isDirectory()) ** GOTO lbl-1000
                var14_13 = new String[]{"zip", "jar"};
                v4 = CollectionsKt.listOf(var14_13);
                Intrinsics.checkNotNullExpressionValue(it, "it");
                if (v4.contains(FilesKt.getExtension(it))) lbl-1000:
                // 2 sources

                {
                    v5 = true;
                } else {
                    v5 = false;
                }
                if (!v5) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            v2 = (List)destination$iv$iv;
        }
        var4_14 = v2;
        return var4_14 == null ? CollectionsKt.emptyList() : var4_14;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<MainResources, List<AddonResources>> loadResources(@NotNull File gameDir) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(gameDir, "gameDir");
        File configDir = LoaderKt.getConfigDir(gameDir);
        LoaderKt.extractDefaultConfig(configDir);
        MainResources mainResources = LoaderKt.loadMainResources(configDir);
        Iterable $this$mapNotNull$iv = LoaderKt.findAddonsOrMakeDir(gameDir);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            AddonResources it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            if (LoaderKt.loadAddonResources(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List allAddonResources = (List)destination$iv$iv;
        return new Pair<MainResources, List<AddonResources>>(mainResources, allAddonResources);
    }

    static {
        String[] stringArray = new String[]{"drops.txt", "sword_drops.txt", "bow_drops.txt", "potion_drops.txt", "natural_gen.txt", "properties.txt", "structures.txt", "luck_crafting.txt"};
        commonConfigFiles = CollectionsKt.listOf(stringArray);
    }
}

