/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.java.loader;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mod.lucky.common.Logger;
import mod.lucky.common.LoggerKt;
import mod.lucky.common.LuckyRegistry;
import mod.lucky.common.Vec3;
import mod.lucky.common.attribute.AttrType;
import mod.lucky.common.attribute.AttributeKt;
import mod.lucky.common.attribute.DictAttr;
import mod.lucky.common.attribute.DictSpec;
import mod.lucky.common.attribute.EvaluatorKt;
import mod.lucky.common.attribute.ParserKt;
import mod.lucky.common.attribute.ValueSpec;
import mod.lucky.common.drop.BaseDrop;
import mod.lucky.common.drop.LuckyStructureKt;
import mod.lucky.common.drop.SingleDrop;
import mod.lucky.common.drop.SingleDropKt;
import mod.lucky.java.JavaGameAPIKt;
import mod.lucky.java.loader.DropStructureResource;
import mod.lucky.java.loader.LoaderKt;
import mod.lucky.java.loader.NBTStructureResource;
import mod.lucky.java.loader.ReadLegacySchematicKt;
import mod.lucky.java.loader.StructureResource;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.Pair;
import mod.lucky.kotlin.TuplesKt;
import mod.lucky.kotlin.collections.CollectionsKt;
import mod.lucky.kotlin.collections.MapsKt;
import mod.lucky.kotlin.io.FilesKt;
import mod.lucky.kotlin.jvm.internal.Intrinsics;
import mod.lucky.kotlin.sequences.SequencesKt;
import mod.lucky.kotlin.text.StringsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u001a(\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a8\u0006\b"}, d2={"readStructures", "", "", "Lmod/lucky/java/loader/StructureResource;", "baseDir", "Ljava/io/File;", "configLines", "", "common"})
public final class ReadStructuresKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, StructureResource> readStructures(@NotNull File baseDir, @NotNull List<String> configLines) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        Map structures;
        Object element$iv$iv$iv3;
        void $this$mapNotNullTo$iv$iv3;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Collection collection;
        Object $this$map$iv2;
        void $this$mapNotNullTo$iv$iv4;
        Intrinsics.checkNotNullParameter(baseDir, "baseDir");
        Intrinsics.checkNotNullParameter(configLines, "configLines");
        DictSpec dictSpec = LuckyRegistry.INSTANCE.getDropSpecs().get("structure");
        Intrinsics.checkNotNull(dictSpec);
        DictSpec dictSpec2 = dictSpec;
        Intrinsics.checkNotNullExpressionValue(dictSpec2, "LuckyRegistry.dropSpecs[\"structure\"]!!");
        DictSpec structSpec = dictSpec2;
        DictSpec defaultPropsSpec = structSpec.copy(MapsKt.plus(structSpec.getChildren(), TuplesKt.to("file", new ValueSpec(AttrType.STRING))));
        Iterable $this$mapNotNull$iv = ParserKt.splitLines(configLines);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<DictAttr> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv4;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            DictAttr it$iv$iv;
            DictAttr attr;
            Object element$iv$iv$iv2;
            Object element$iv$iv = element$iv$iv$iv2 = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            try {
                attr = (DictAttr)EvaluatorKt.parseEvalAttr(it, defaultPropsSpec, LuckyRegistry.INSTANCE.getParserContext(), LuckyRegistry.INSTANCE.getSimpleEvalContext());
                attr = SingleDropKt.processProps(SingleDrop.Companion, "structure", attr);
            }
            catch (Exception e) {
                LoggerKt.getLOGGER().logError(Intrinsics.stringPlus("Error reading structure settings: ", it), e);
                attr = null;
            }
            if (attr == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List overridePropsList = (List)destination$iv$iv;
        try {
            List list;
            Iterable $this$mapTo$iv$iv2;
            boolean $i$f$mapTo;
            boolean $i$f$map22;
            Object it;
            Object element$iv$iv;
            Iterator $i$f$forEach2;
            Object $this$filterTo$iv$iv2;
            boolean $i$f$filterTo;
            Collection destination$iv$iv2;
            boolean $i$f$filter;
            Iterable $this$filter$iv2;
            if (baseDir.isDirectory()) {
                $this$filter$iv2 = SequencesKt.toList(FilesKt.walk$default(baseDir, null, 1, null));
                $i$f$filter = false;
                destination$iv$iv = $this$filter$iv2;
                destination$iv$iv2 = new ArrayList();
                $i$f$filterTo = false;
                $i$f$forEach2 = $this$filterTo$iv$iv2.iterator();
                while ($i$f$forEach2.hasNext()) {
                    element$iv$iv = $i$f$forEach2.next();
                    it = (File)element$iv$iv;
                    boolean bl = false;
                    if (!(!((File)it).isDirectory())) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv2 = (List)destination$iv$iv2;
                $i$f$map22 = false;
                $this$filterTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                $i$f$mapTo = false;
                for (Iterator item$iv$iv : $this$mapTo$iv$iv2) {
                    it = (File)((Object)item$iv$iv);
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(FilesKt.relativeTo((File)it, baseDir).getPath());
                }
                list = (List)destination$iv$iv2;
            } else {
                $this$map$iv2 = new ZipFile(baseDir).entries();
                Intrinsics.checkNotNullExpressionValue($this$map$iv2, "ZipFile(baseDir).entries()");
                ArrayList $i$f$map22 = Collections.list($this$map$iv2);
                Intrinsics.checkNotNullExpressionValue($i$f$map22, "list(this)");
                $this$map$iv2 = $i$f$map22;
                $i$f$filter = false;
                $this$mapTo$iv$iv2 = $this$filter$iv2;
                destination$iv$iv2 = new ArrayList();
                $i$f$filterTo = false;
                $i$f$forEach2 = $this$filterTo$iv$iv2.iterator();
                while ($i$f$forEach2.hasNext()) {
                    element$iv$iv = $i$f$forEach2.next();
                    it = (ZipEntry)element$iv$iv;
                    boolean bl = false;
                    if (!(!((ZipEntry)it).isDirectory())) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv2 = (List)destination$iv$iv2;
                $i$f$map22 = false;
                $this$filterTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                $i$f$mapTo = false;
                for (Iterator item$iv$iv : $this$mapTo$iv$iv2) {
                    it = (ZipEntry)((Object)item$iv$iv);
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(((ZipEntry)it).getName());
                }
                list = (List)destination$iv$iv2;
            }
            $this$map$iv2 = list;
        }
        catch (Exception e) {
            LoggerKt.getLOGGER().logError("Error searching for structures", e);
            $this$map$iv2 = CollectionsKt.emptyList();
        }
        List filePaths = $this$map$iv2;
        Iterable e = filePaths;
        boolean $i$f$map = false;
        void destination$iv$iv3 = $this$map$iv;
        Iterable destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl4 = false;
            collection.add(StringsKt.replace$default((String)it, File.separatorChar, '/', false, 4, null));
        }
        $this$map$iv = (List)destination$iv$iv4;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(StringsKt.startsWith$default(it, "structures/", false, 2, null) || StringsKt.contains$default((CharSequence)it, "/structures/", false, 2, null))) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        List structPaths = (List)destination$iv$iv4;
        Iterable $this$mapNotNull$iv2 = structPaths;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv4 = $this$mapNotNull$iv2;
        Object destination$iv$iv5 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv3;
        boolean $i$f$forEach3 = false;
        for (Object element$iv$iv$iv3 : $this$forEach$iv$iv$iv2) {
            Object it$iv$iv;
            Object stream;
            Object element$iv$iv = element$iv$iv$iv3;
            boolean bl = false;
            String fullPath = (String)element$iv$iv;
            boolean bl5 = false;
            String string = fullPath.substring(StringsKt.indexOf$default((CharSequence)fullPath, "structures/", 0, false, 6, null) + "structures/".length());
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            String path = string;
            try {
                Pair<String, StructureResource> pair;
                List<BaseDrop> drops;
                DictAttr props;
                Pair<Object, Vec3<Integer>> pair2;
                InputStream inputStream = LoaderKt.getInputStream(baseDir, fullPath);
                Intrinsics.checkNotNull(inputStream);
                stream = inputStream;
                if (StringsKt.endsWith$default(path, ".luckystruct", false, 2, null)) {
                    pair2 = LuckyStructureKt.readLuckyStructure(LoaderKt.readLines((InputStream)stream));
                    props = pair2.component1();
                    drops = pair2.component2();
                    pair = TuplesKt.to(path, new DropStructureResource(props, drops));
                } else if (StringsKt.endsWith$default(path, ".schematic", false, 2, null)) {
                    pair2 = ReadLegacySchematicKt.readLegacySchematic((InputStream)stream);
                    props = ((DropStructureResource)((Object)pair2)).component1();
                    drops = ((DropStructureResource)((Object)pair2)).component2();
                    pair = TuplesKt.to(path, new DropStructureResource(props, drops));
                } else if (StringsKt.endsWith$default(path, ".nbt", false, 2, null)) {
                    pair2 = JavaGameAPIKt.getJAVA_GAME_API().readNBTStructure((InputStream)stream);
                    Object structure = pair2.component1();
                    Vec3<Integer> size = pair2.component2();
                    Pair[] pairArray = new Pair[]{TuplesKt.to("size", AttributeKt.vec3AttrOf(AttrType.DOUBLE, size.toDouble()))};
                    DictAttr props2 = AttributeKt.dictAttrOf(pairArray);
                    pair = TuplesKt.to(path, new NBTStructureResource(props2, structure));
                } else {
                    pair = null;
                }
                stream = pair;
            }
            catch (Exception e2) {
                LoggerKt.getLOGGER().logError("Error reading structure '" + path + '\'', e2);
                stream = null;
            }
            if (stream == null) continue;
            boolean bl6 = false;
            destination$iv$iv5.add(it$iv$iv);
        }
        Map $this$mapNotNull$iv3 = structures = MapsKt.toMap((List)destination$iv$iv5);
        boolean $i$f$mapNotNull3 = false;
        destination$iv$iv5 = $this$mapNotNull$iv3;
        Iterable<Pair<String, StructureResource>> destination$iv$iv6 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach4 = false;
        element$iv$iv$iv3 = $this$forEach$iv$iv$iv3.entrySet().iterator();
        while (element$iv$iv$iv3.hasNext()) {
            Pair<String, StructureResource> pair;
            Map.Entry element$iv$iv$iv4;
            Map.Entry element$iv$iv = element$iv$iv$iv4 = (Map.Entry)element$iv$iv$iv3.next();
            boolean bl = false;
            Map.Entry $dstr$_u24__u24$structure = element$iv$iv;
            boolean bl7 = false;
            StructureResource structure = (StructureResource)$dstr$_u24__u24$structure.getValue();
            if ((String)structure.getDefaultProps().getOptionalValue("id") == null) {
                pair = null;
            } else {
                String it;
                boolean bl8 = false;
                pair = TuplesKt.to(it, structure);
            }
            if (pair == null) continue;
            Pair<String, StructureResource> it$iv$iv = pair;
            boolean bl9 = false;
            destination$iv$iv6.add(it$iv$iv);
        }
        Map aliasedStructures = MapsKt.toMap((List)destination$iv$iv6);
        Iterable $this$mapNotNull$iv4 = overridePropsList;
        boolean $i$f$mapNotNull4 = false;
        destination$iv$iv6 = $this$mapNotNull$iv4;
        Collection destination$iv$iv7 = new ArrayList();
        boolean $i$f$mapNotNullTo4 = false;
        void $this$forEach$iv$iv$iv4 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach5 = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv4.iterator();
        while (iterator3.hasNext()) {
            Pair<String, StructureResource> pair;
            Object element$iv$iv$iv5;
            Object element$iv$iv = element$iv$iv$iv5 = iterator3.next();
            boolean bl = false;
            DictAttr props = (DictAttr)element$iv$iv;
            boolean bl10 = false;
            String path = (String)props.getOptionalValue("file");
            if (path == null || !structures.containsKey(path)) {
                Logger.DefaultImpls.logError$default(LoggerKt.getLOGGER(), "Error in structures.txt: Structure with path '" + path + "' doesn't exist", null, 2, null);
                pair = null;
            } else if ((String)props.getOptionalValue("id") == null) {
                pair = null;
            } else {
                String it;
                boolean bl11 = false;
                Object v = structures.get(path);
                Intrinsics.checkNotNull(v);
                StructureResource struct = (StructureResource)v;
                StructureResource newStruct = struct instanceof DropStructureResource ? (StructureResource)DropStructureResource.copy$default((DropStructureResource)struct, AttributeKt.withDefaults(props, struct.getDefaultProps().getChildren()), null, 2, null) : (struct instanceof NBTStructureResource ? (StructureResource)NBTStructureResource.copy$default((NBTStructureResource)struct, AttributeKt.withDefaults(props, struct.getDefaultProps().getChildren()), null, 2, null) : struct);
                pair = TuplesKt.to(it, newStruct);
            }
            if (pair == null) continue;
            Pair<String, StructureResource> it$iv$iv = pair;
            boolean bl12 = false;
            destination$iv$iv7.add(it$iv$iv);
        }
        Map configuredStructures = MapsKt.toMap((List)destination$iv$iv7);
        return MapsKt.plus(MapsKt.plus(structures, aliasedStructures), configuredStructures);
    }
}

