/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric;

import fr.raksrinana.fallingtree.fabric.FallingTree;
import fr.raksrinana.fallingtree.fabric.config.BreakMode;
import fr.raksrinana.fallingtree.fabric.tree.Tree;
import fr.raksrinana.fallingtree.fabric.tree.breaking.BreakTreeTooBigException;
import fr.raksrinana.fallingtree.fabric.tree.breaking.ITreeBreakingHandler;
import fr.raksrinana.fallingtree.fabric.tree.breaking.InstantaneousTreeBreakingHandler;
import fr.raksrinana.fallingtree.fabric.tree.breaking.ShiftDownTreeBreakingHandler;
import fr.raksrinana.fallingtree.fabric.tree.builder.TreeBuilder;
import fr.raksrinana.fallingtree.fabric.tree.builder.TreeTooBigException;
import fr.raksrinana.fallingtree.fabric.utils.FallingTreeUtils;
import java.util.Optional;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;

public class BlockBreakHandler
implements PlayerBlockBreakEvents.Before {
    public boolean beforeBlockBreak(class_1937 world, class_1657 player, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
        if (FallingTree.config.getTrees().isTreeBreaking() && !world.method_8608() && FallingTreeUtils.isPlayerInRightState(player, blockState)) {
            try {
                Optional<Tree> treeOptional = TreeBuilder.getTree(player, world, blockPos);
                if (treeOptional.isEmpty()) {
                    return true;
                }
                Tree tree = treeOptional.get();
                BreakMode breakMode = FallingTree.config.getTrees().getBreakMode();
                return BlockBreakHandler.getBreakingHandler(breakMode).breakTree(player, tree);
            }
            catch (TreeTooBigException e) {
                FallingTreeUtils.notifyPlayer(player, (class_2561)new class_2588("chat.fallingtree.tree_too_big", new Object[]{FallingTree.config.getTrees().getMaxScanSize()}));
                return true;
            }
            catch (BreakTreeTooBigException e) {
                FallingTreeUtils.notifyPlayer(player, (class_2561)new class_2588("chat.fallingtree.break_tree_too_big", new Object[]{FallingTree.config.getTrees().getMaxSize()}));
                return true;
            }
        }
        return true;
    }

    public static ITreeBreakingHandler getBreakingHandler(BreakMode breakMode) {
        return switch (breakMode) {
            default -> throw new IncompatibleClassChangeError();
            case BreakMode.INSTANTANEOUS -> InstantaneousTreeBreakingHandler.getInstance();
            case BreakMode.SHIFT_DOWN -> ShiftDownTreeBreakingHandler.getInstance();
        };
    }
}

