/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.leaves;

import fr.raksrinana.fallingtree.forge.config.Config;
import fr.raksrinana.fallingtree.forge.leaves.LeafBreakingSchedule;
import fr.raksrinana.fallingtree.forge.utils.FallingTreeUtils;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fallingtree", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LeafBreakingHandler {
    private static final Set<LeafBreakingSchedule> scheduledLeavesBreaking = ConcurrentHashMap.newKeySet();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            Iterator<LeafBreakingSchedule> leavesBreak = scheduledLeavesBreaking.iterator();
            while (leavesBreak.hasNext()) {
                LeafBreakingSchedule leafBreakingSchedule = leavesBreak.next();
                ServerLevel level = leafBreakingSchedule.getLevel();
                if (leafBreakingSchedule.getRemainingTicks() <= 0) {
                    ChunkAccess chunk = level.m_46865_(leafBreakingSchedule.getBlockPos());
                    ChunkPos chunkPos = chunk.m_7697_();
                    if (level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) {
                        BlockState state = level.m_8055_(leafBreakingSchedule.getBlockPos());
                        state.m_60616_(level, leafBreakingSchedule.getBlockPos(), level.m_5822_());
                        if (state.m_60823_()) {
                            state.m_60735_(level, leafBreakingSchedule.getBlockPos(), level.m_5822_());
                        }
                    }
                    leavesBreak.remove();
                    continue;
                }
                leafBreakingSchedule.tick();
            }
        }
    }

    @SubscribeEvent
    public static void onNeighborNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor levelAccessor;
        if (Config.COMMON.getTrees().isLeavesBreaking() && !event.getWorld().m_5776_() && (levelAccessor = event.getWorld()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            BlockState eventState = event.getState();
            Block eventBlock = eventState.m_60734_();
            BlockPos eventPos = event.getPos();
            if (eventBlock.equals(Blocks.f_50016_)) {
                for (Direction facing : event.getNotifiedSides()) {
                    BlockState neighborState;
                    BlockPos neighborPos = eventPos.m_142300_(facing);
                    ChunkAccess chunk = level.m_46865_(neighborPos);
                    ChunkPos chunkPos = chunk.m_7697_();
                    if (!level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_) || !FallingTreeUtils.isLeafBlock((neighborState = event.getWorld().m_8055_(neighborPos)).m_60734_())) continue;
                    scheduledLeavesBreaking.add(new LeafBreakingSchedule(level, neighborPos, 4));
                }
            }
        }
    }
}

