/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.tree;

import fr.raksrinana.fallingtree.forge.FallingTreeBlockBreakEvent;
import fr.raksrinana.fallingtree.forge.config.BreakMode;
import fr.raksrinana.fallingtree.forge.config.Config;
import fr.raksrinana.fallingtree.forge.tree.Tree;
import fr.raksrinana.fallingtree.forge.tree.breaking.BreakTreeTooBigException;
import fr.raksrinana.fallingtree.forge.tree.breaking.ITreeBreakingHandler;
import fr.raksrinana.fallingtree.forge.tree.breaking.InstantaneousTreeBreakingHandler;
import fr.raksrinana.fallingtree.forge.tree.breaking.ShiftDownTreeBreakingHandler;
import fr.raksrinana.fallingtree.forge.tree.builder.TreeBuilder;
import fr.raksrinana.fallingtree.forge.tree.builder.TreeTooBigException;
import fr.raksrinana.fallingtree.forge.utils.CacheSpeed;
import fr.raksrinana.fallingtree.forge.utils.FallingTreeUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fallingtree", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BreakingHandler {
    private static final Map<UUID, CacheSpeed> speedCache = new ConcurrentHashMap<UUID, CacheSpeed>();

    @SubscribeEvent
    public static void onBreakSpeed(@Nonnull PlayerEvent.BreakSpeed event) {
        CacheSpeed cacheSpeed;
        if (Config.COMMON.getTrees().isTreeBreaking() && !event.isCanceled() && Config.COMMON.getTrees().getBreakMode() == BreakMode.INSTANTANEOUS && BreakingHandler.isPlayerInRightState(event.getPlayer(), event.getState()) && Objects.nonNull(cacheSpeed = speedCache.compute(event.getPlayer().m_142081_(), (pos, speed) -> {
            if (Objects.isNull(speed) || !speed.isValid(event.getPos())) {
                speed = BreakingHandler.getSpeed(event);
            }
            return speed;
        }))) {
            event.setNewSpeed(cacheSpeed.getSpeed());
        }
    }

    @SubscribeEvent
    public static void onBlockBreakEvent(@Nonnull BlockEvent.BreakEvent event) {
        if (Config.COMMON.getTrees().isTreeBreaking() && !event.isCanceled() && !event.getWorld().m_5776_()) {
            LevelAccessor levelAccessor;
            if (event instanceof FallingTreeBlockBreakEvent) {
                return;
            }
            Player player = event.getPlayer();
            if (BreakingHandler.isPlayerInRightState(player, event.getState()) && (levelAccessor = event.getWorld()) instanceof Level) {
                Level level = (Level)levelAccessor;
                try {
                    Optional<Tree> treeOptional = TreeBuilder.getTree(player, level, event.getPos());
                    if (treeOptional.isEmpty()) {
                        return;
                    }
                    Tree tree = treeOptional.get();
                    BreakMode breakMode = Config.COMMON.getTrees().getBreakMode();
                    BreakingHandler.getBreakingHandler(breakMode).breakTree(event, tree);
                }
                catch (TreeTooBigException e) {
                    FallingTreeUtils.notifyPlayer(player, (Component)new TranslatableComponent("chat.fallingtree.tree_too_big", new Object[]{Config.COMMON.getTrees().getMaxScanSize()}));
                }
                catch (BreakTreeTooBigException e) {
                    FallingTreeUtils.notifyPlayer(player, (Component)new TranslatableComponent("chat.fallingtree.break_tree_too_big", new Object[]{Config.COMMON.getTrees().getMaxSize()}));
                }
            }
        }
    }

    public static ITreeBreakingHandler getBreakingHandler(BreakMode breakMode) {
        return switch (breakMode) {
            default -> throw new IncompatibleClassChangeError();
            case BreakMode.INSTANTANEOUS -> InstantaneousTreeBreakingHandler.getInstance();
            case BreakMode.SHIFT_DOWN -> ShiftDownTreeBreakingHandler.getInstance();
        };
    }

    private static boolean isPlayerInRightState(Player player, BlockState aimedBlockState) {
        if (player.m_7500_() && !Config.COMMON.isBreakInCreative()) {
            return false;
        }
        if (Config.COMMON.isReverseSneaking() != player.m_6047_()) {
            return false;
        }
        return FallingTreeUtils.canPlayerBreakTree(player, aimedBlockState);
    }

    private static CacheSpeed getSpeed(PlayerEvent.BreakSpeed event) {
        double speedMultiplicand = Config.COMMON.getTools().getSpeedMultiplicand();
        try {
            Player player = event.getPlayer();
            return speedMultiplicand <= 0.0 ? null : (CacheSpeed)TreeBuilder.getTree(player, player.m_20193_(), event.getPos()).map(tree -> new CacheSpeed(event.getPos(), event.getNewSpeed() / ((float)speedMultiplicand * (float)tree.getLogCount()))).orElse(null);
        }
        catch (TreeTooBigException e) {
            return null;
        }
    }
}

