/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.tree.breaking;

import fr.raksrinana.fallingtree.forge.FallingTree;
import fr.raksrinana.fallingtree.forge.config.Config;
import fr.raksrinana.fallingtree.forge.config.DamageRounding;
import fr.raksrinana.fallingtree.forge.config.MaxSizeAction;
import fr.raksrinana.fallingtree.forge.tree.breaking.BreakTreeTooBigException;
import net.minecraft.world.item.ItemStack;

public class ToolDamageHandler {
    private final ItemStack tool;
    private final double damageMultiplicand;
    private final int maxDurabilityTaken;
    private final int maxBreakCount;

    public ToolDamageHandler(ItemStack tool, double damageMultiplicand, boolean preserve, int breakableCount) throws BreakTreeTooBigException {
        int tempMaxBreakCount;
        this.tool = tool;
        this.damageMultiplicand = damageMultiplicand;
        int maxSize = Config.COMMON.getTrees().getMaxSize();
        if (breakableCount > maxSize && Config.COMMON.getTrees().getMaxSizeAction() == MaxSizeAction.ABORT) {
            FallingTree.logger.debug("Tree reached max size of {}", (Object)maxSize);
            throw new BreakTreeTooBigException();
        }
        if (tool.m_41763_()) {
            int breakCount;
            int n = breakCount = damageMultiplicand == 0.0 ? maxSize : (int)Math.floor((double)this.getToolDurability() / damageMultiplicand);
            if (preserve && breakCount <= breakableCount) {
                --breakCount;
            }
            tempMaxBreakCount = breakCount;
        } else {
            tempMaxBreakCount = maxSize;
        }
        this.maxBreakCount = Math.min(maxSize, tempMaxBreakCount);
        this.maxDurabilityTaken = this.getDamage(this.maxBreakCount);
    }

    private int getDamage(long count) {
        if (Double.compare(this.damageMultiplicand, 0.0) <= 0) {
            return 1;
        }
        double rawDamage = (double)count * this.damageMultiplicand;
        return switch (Config.COMMON.getTools().getDamageRounding()) {
            default -> throw new IncompatibleClassChangeError();
            case DamageRounding.ROUND_DOWN -> (int)Math.floor(rawDamage);
            case DamageRounding.ROUND_UP -> (int)Math.ceil(rawDamage);
            case DamageRounding.ROUNDING -> (int)Math.round(rawDamage);
            case DamageRounding.PROBABILISTIC -> this.getProbabilisticDamage(rawDamage);
        };
    }

    private int getProbabilisticDamage(double rawDamage) {
        double damage = Math.floor(rawDamage);
        int finalDamage = (int)damage;
        double probability = rawDamage - damage;
        if (Math.random() < probability) {
            ++finalDamage;
        }
        return finalDamage;
    }

    public int getActualDamage(int brokenCount) {
        if (this.tool.m_41763_()) {
            return brokenCount == this.maxBreakCount ? this.maxDurabilityTaken : Math.min(this.maxDurabilityTaken, this.getDamage(brokenCount));
        }
        return 0;
    }

    private int getToolDurability() {
        if (this.tool.m_41763_()) {
            return this.tool.m_41776_() - this.tool.m_41773_();
        }
        return Integer.MAX_VALUE;
    }

    public int getMaxBreakCount() {
        return this.maxBreakCount;
    }
}

