/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.utils;

import java.util.Objects;
import net.minecraft.core.BlockPos;

public class CacheSpeed {
    private final BlockPos pos;
    private final float speed;
    private final long millis;

    public CacheSpeed(BlockPos pos, float speed) {
        this.pos = pos;
        this.speed = speed;
        this.millis = System.currentTimeMillis();
    }

    public boolean isValid(BlockPos blockPos) {
        return this.millis + 1000L >= System.currentTimeMillis() && Objects.equals(this.pos, blockPos);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public float getSpeed() {
        return this.speed;
    }

    public long getMillis() {
        return this.millis;
    }
}

